/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.world.logic.IWeatherController;
import com.xcompwiz.mystcraft.api.world.storage.StorageObject;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class WeatherControllerBase
implements IWeatherController {
    private Random random = new Random();
    private int updateLCG = this.random.nextInt();
    private StorageObject infoObj;
    private double rainingStrength;
    private double thunderingStrength;
    protected int rain_duration;
    protected int rain_duration_base;
    protected int rain_cooldown;
    protected int rain_cooldown_base;
    protected int thunder_duration;
    protected int thunder_duration_base;
    protected int thunder_cooldown;
    protected int thunder_cooldown_base;

    @Override
    public void setDataObject(StorageObject infoObj) {
        this.infoObj = infoObj;
        if (infoObj.getBoolean("raining")) {
            this.rainingStrength = 1.0;
        }
        if (infoObj.getBoolean("thundering")) {
            this.thunderingStrength = 1.0;
        }
    }

    @Override
    public void updateRaining() {
        int thunder_counter = this.infoObj.getInteger("thunder_counter");
        if (thunder_counter <= 0) {
            if (this.infoObj.getBoolean("thundering")) {
                thunder_counter = this.thunder_duration_base;
                if (this.thunder_duration > 0) {
                    thunder_counter += this.random.nextInt(this.thunder_duration);
                }
                this.infoObj.setInteger("thunder_counter", thunder_counter);
            } else {
                thunder_counter = this.thunder_cooldown_base;
                if (this.thunder_cooldown > 0) {
                    thunder_counter += this.random.nextInt(this.thunder_cooldown);
                }
                this.infoObj.setInteger("thunder_counter", thunder_counter);
            }
        } else {
            this.infoObj.setInteger("thunder_counter", --thunder_counter);
            if (thunder_counter <= 0) {
                this.infoObj.setBoolean("thundering", !this.infoObj.getBoolean("thundering"));
            }
        }
        int rain_counter = this.infoObj.getInteger("rain_counter");
        if (rain_counter <= 0) {
            if (this.infoObj.getBoolean("raining")) {
                rain_counter = this.rain_duration_base;
                if (this.rain_duration > 0) {
                    rain_counter += this.random.nextInt(this.rain_duration);
                }
                this.infoObj.setInteger("rain_counter", rain_counter);
            } else {
                rain_counter = this.rain_cooldown_base;
                if (this.rain_cooldown > 0) {
                    rain_counter += this.random.nextInt(this.rain_cooldown);
                }
                this.infoObj.setInteger("rain_counter", rain_counter);
            }
        } else {
            this.infoObj.setInteger("rain_counter", --rain_counter);
            if (rain_counter <= 0) {
                this.infoObj.setBoolean("raining", !this.infoObj.getBoolean("raining"));
            }
        }
        this.rainingStrength = this.infoObj.getBoolean("raining") ? (this.rainingStrength += 0.01) : (this.rainingStrength -= 0.01);
        if (this.rainingStrength < 0.0) {
            this.rainingStrength = 0.0;
        }
        if (this.rainingStrength > 1.0) {
            this.rainingStrength = 1.0;
        }
        this.thunderingStrength = this.infoObj.getBoolean("thundering") ? (this.thunderingStrength += 0.01) : (this.thunderingStrength -= 0.01);
        if (this.thunderingStrength < 0.0) {
            this.thunderingStrength = 0.0;
        }
        if (this.thunderingStrength > 1.0) {
            this.thunderingStrength = 1.0;
        }
    }

    @Override
    public void tick(World worldObj, Chunk chunk) {
        if (worldObj.func_72896_J() && worldObj.func_72911_I() && worldObj.field_73012_v.nextInt(100000) == 0) {
            int xBase = chunk.field_76635_g * 16;
            int zBase = chunk.field_76647_h * 16;
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int coords = this.updateLCG >> 2;
            int x = xBase + (coords & 0xF);
            int z = zBase + (coords >> 8 & 0xF);
            BlockPos precip = worldObj.func_175725_q(new BlockPos(x, 0, z));
            if (worldObj.func_175727_C(precip)) {
                worldObj.func_72942_c((Entity)new EntityLightningBolt(worldObj, (double)precip.func_177958_n(), (double)precip.func_177956_o(), (double)precip.func_177952_p(), false));
            }
        }
    }

    @Override
    public void reset() {
        this.infoObj.setInteger("rain_counter", 0);
        this.infoObj.setBoolean("raining", false);
        this.infoObj.setInteger("thunder_counter", 0);
        this.infoObj.setBoolean("thundering", false);
    }

    @Override
    public void togglePrecipitation() {
        this.infoObj.setInteger("rain_counter", 1);
    }

    @Override
    public float getRainingStrength() {
        return (float)this.rainingStrength;
    }

    @Override
    public float getStormStrength() {
        return (float)this.thunderingStrength;
    }

    @Override
    public float getTemperature(float current, ResourceLocation biomeId) {
        return current;
    }

    @Override
    public float getRainfall(float current, ResourceLocation biomeId) {
        return current;
    }

    @Override
    public boolean getEnableSnow(boolean current, ResourceLocation biomeId) {
        return current;
    }

    @Override
    public boolean getEnableRain(boolean current, ResourceLocation biomeId) {
        return current;
    }
}

