/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SymbolBase
implements IAgeSymbol {
    protected final ResourceLocation registryName;
    private ArrayList<GrammarGenerator.Rule> rules;
    private String[] words;
    @SideOnly(value=Side.CLIENT)
    private String localizedName;

    public SymbolBase(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public void setWords(String[] words) {
        this.words = words;
    }

    public IAgeSymbol setCardRank(Integer cardrank) {
        if (cardrank == null) {
            return this;
        }
        InternalAPI.symbolValues.setSymbolCardRank(this, cardrank);
        return this;
    }

    public final ArrayList<GrammarGenerator.Rule> getRules() {
        ArrayList<GrammarGenerator.Rule> out = this.createRules();
        if (this.rules != null) {
            if (out == null) {
                out = new ArrayList();
            }
            out.addAll(this.rules);
        }
        return out;
    }

    protected ArrayList<GrammarGenerator.Rule> createRules() {
        return null;
    }

    public void addRule(GrammarGenerator.Rule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        this.rules.add(rule);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public IAgeSymbol setRegistryName(ResourceLocation registryName) {
        return this;
    }

    protected String getUnlocalizedName() {
        return "myst.symbol." + this.getRegistryName().func_110623_a();
    }

    @SideOnly(value=Side.CLIENT)
    protected String generateLocalizedName() {
        return I18n.func_135052_a((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        if (this.localizedName == null) {
            this.localizedName = this.generateLocalizedName();
        }
        return this.localizedName;
    }

    @Override
    public abstract void registerLogic(AgeDirector var1, long var2);

    @Override
    public int instabilityModifier(int count) {
        return 0;
    }

    @Override
    public final String[] getPoem() {
        return this.words;
    }
}

