/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.ModGUIs;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPortfolio
extends Item
implements IItemPageCollection,
IItemRenameable,
IItemOnLoadable {
    public ItemPortfolio() {
        this.func_77625_d(1);
        this.func_77655_b("myst.portfolio");
        this.func_77637_a(MystcraftCommonProxy.tabMystCommon);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String name = this.getDisplayName((EntityPlayer)Minecraft.func_71410_x().field_71439_g, itemstack);
        if (name != null) {
            tooltip.add(name);
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && held.func_190916_E() == 1) {
            playerIn.openGui((Object)Mystcraft.instance, ModGUIs.PORTFOLIO.ordinal(), worldIn, MathHelper.func_76128_c((double)(playerIn.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70163_u + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70161_v + 0.5)));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
    }

    @Override
    @Nullable
    public String getDisplayName(@Nullable EntityPlayer player, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("Name")) {
            return null;
        }
        return stack.func_77978_p().func_74779_i("Name");
    }

    @Override
    public void setDisplayName(EntityPlayer player, @Nonnull ItemStack stack, String name) {
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (name == null || name.equals("")) {
            stack.func_77978_p().func_82580_o("Name");
        } else {
            stack.func_77978_p().func_74778_a("Name", name);
        }
    }

    public static boolean isItemValid(@Nonnull ItemStack itemstack) {
        return !itemstack.func_190926_b() && itemstack.func_77973_b().equals(ModItems.page);
    }

    @Override
    @Nonnull
    public ItemStack remove(EntityPlayer player, @Nonnull ItemStack itemstack, @Nonnull ItemStack page) {
        int removed;
        if (itemstack.func_190926_b() || page.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        LinkedList<NBTTagCompound> compounds = NBTUtils.readTagCompoundCollection(itemstack.func_77978_p().func_150295_c("Collection", 10), new LinkedList());
        NBTTagCompound nbt = new NBTTagCompound();
        int count = page.func_190916_E();
        page.func_190920_e(1);
        page.func_77955_b(nbt);
        for (removed = 0; removed < count && compounds.remove(nbt); ++removed) {
        }
        if (removed <= 0) {
            return ItemStack.field_190927_a;
        }
        itemstack.func_77978_p().func_74782_a("Collection", (NBTBase)NBTUtils.writeTagCompoundCollection(new NBTTagList(), compounds));
        page.func_190920_e(removed);
        return page;
    }

    @Override
    @Nonnull
    public ItemStack addPage(EntityPlayer player, @Nonnull ItemStack itemstack, @Nonnull ItemStack page) {
        if (itemstack.func_190926_b() || page.func_190926_b()) {
            return page;
        }
        if (page.func_77973_b() instanceof IItemPageCollection) {
            if (page.func_190916_E() != 1) {
                return page;
            }
            IItemPageCollection otheritem = (IItemPageCollection)page.func_77973_b();
            List<ItemStack> pages = otheritem.getItems(player, page);
            for (ItemStack p : pages) {
                ItemStack out = this.addPage(player, itemstack, otheritem.remove(player, page, p));
                if (out.func_190926_b()) continue;
                otheritem.addPage(player, page, out);
            }
            return page;
        }
        if (page.func_77973_b() instanceof IItemOrderablePageProvider) {
            if (page.func_190916_E() != 1) {
                return page;
            }
            IItemOrderablePageProvider otheritem = (IItemOrderablePageProvider)page.func_77973_b();
            List<ItemStack> pages = otheritem.getPageList(player, page);
            for (int i = 0; i < pages.size(); ++i) {
                ItemStack out = this.addPage(player, itemstack, otheritem.removePage(player, page, i));
                if (out.func_190926_b()) continue;
                otheritem.addPage(player, page, out);
            }
            return page;
        }
        if (!ItemPortfolio.isItemValid(page)) {
            return page;
        }
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        LinkedList<NBTTagCompound> compounds = NBTUtils.readTagCompoundCollection(itemstack.func_77978_p().func_150295_c("Collection", 10), new LinkedList());
        NBTTagCompound nbt = new NBTTagCompound();
        int count = page.func_190916_E();
        page.func_190920_e(1);
        for (int i = 0; i < count; ++i) {
            page.func_77955_b(nbt);
            compounds.add(nbt);
        }
        itemstack.func_77978_p().func_74782_a("Collection", (NBTBase)NBTUtils.writeTagCompoundCollection(new NBTTagList(), compounds));
        return ItemStack.field_190927_a;
    }

    @Override
    @Nullable
    public List<ItemStack> getItems(EntityPlayer player, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        LinkedList<NBTTagCompound> compounds = NBTUtils.readTagCompoundCollection(itemstack.func_77978_p().func_150295_c("Collection", 10), new LinkedList());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (NBTTagCompound nbt : compounds) {
            ItemStack page = new ItemStack(nbt);
            items.add(page);
        }
        return items;
    }

    @Override
    @Nonnull
    public ItemStack onLoad(@Nonnull ItemStack itemstack) {
        ItemPortfolio.updatePages(itemstack);
        return itemstack;
    }

    public static void updatePages(@Nonnull ItemStack itemstack) {
        LinkedList<NBTTagCompound> compounds = NBTUtils.readTagCompoundCollection(itemstack.func_77978_p().func_150295_c("Collection", 10), new LinkedList());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (NBTTagCompound nbt : compounds) {
            ItemStack page = new ItemStack(nbt);
            List<ItemStack> results = SymbolRemappings.remap(page);
            items.addAll(results);
        }
        compounds.clear();
        for (ItemStack page : items) {
            NBTTagCompound nbt = new NBTTagCompound();
            page.func_77955_b(nbt);
            compounds.add(nbt);
        }
        itemstack.func_77978_p().func_74782_a("Collection", (NBTBase)NBTUtils.writeTagCompoundCollection(new NBTTagList(), compounds));
    }
}

