/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPage
extends Item
implements IItemRenameable,
IItemWritable,
IItemPageProvider,
IItemOnLoadable {
    public ItemPage() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77655_b("myst.page");
        this.func_77637_a(MystcraftCommonProxy.tabMystPages);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)Page.createLinkPage());
            ArrayList<String> linkproperties = new ArrayList<String>();
            linkproperties.addAll(InkEffects.getProperties());
            Collections.sort(linkproperties);
            for (String property : linkproperties) {
                if (property.equals("Relative")) continue;
                items.add((Object)Page.createLinkPage(property));
            }
            ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
            symbols.sort(SortingUtils.ComparatorSymbolAlphabetical.instance);
            for (IAgeSymbol symbol2 : symbols) {
                items.add((Object)Page.createSymbolPage(symbol2.getRegistryName()));
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(@Nonnull ItemStack itemstack) {
        if (itemstack.func_77978_p() != null) {
            if (Page.isLinkPanel(itemstack)) {
                return I18n.func_135052_a((String)(this.func_77667_c(itemstack) + ".panel.name"), (Object[])new Object[0]);
            }
            if (Page.isBlank(itemstack)) {
                return I18n.func_135052_a((String)(this.func_77667_c(itemstack) + ".blank.name"), (Object[])new Object[0]);
            }
            ResourceLocation symbolId = Page.getSymbol(itemstack);
            IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(symbolId);
            if (symbol2 == null) {
                return I18n.func_135052_a((String)(this.func_77667_c(itemstack) + ".symbol.name"), (Object[])new Object[0]) + " (Unknown: " + symbolId + ")";
            }
            return I18n.func_135052_a((String)(this.func_77667_c(itemstack) + ".symbol.name"), (Object[])new Object[0]) + " (" + symbol2.getLocalizedName() + ")";
        }
        return I18n.func_135052_a((String)(this.func_77667_c(itemstack) + ".blank.name"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (itemstack.func_77978_p() != null) {
            Page.getTooltip(itemstack, tooltip);
        }
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, World world, Entity entity, int itemSlot, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        if (Page.isBlank(itemstack)) {
            itemstack.func_77982_d(null);
        }
        if (itemstack.func_77978_p() == null) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemPage.remapItemstack(player, itemstack, itemSlot);
        }
    }

    private static void remapItemstack(@Nonnull ItemStack stack) {
        ItemPage.remapItemstack(null, stack, -1);
    }

    public static void remapItemstack(EntityPlayer player, @Nonnull ItemStack itemstack, int itemSlot) {
        List<ItemStack> mapping = SymbolRemappings.remap(itemstack);
        if (mapping.size() == 0) {
            itemstack.func_190920_e(0);
        }
        if (mapping.size() != 1 && player != null) {
            ItemStack folder = new ItemStack(ModItems.folder);
            IItemOrderablePageProvider item = (IItemOrderablePageProvider)folder.func_77973_b();
            folder.func_77982_d(new NBTTagCompound());
            for (ItemStack mappeditemstack : mapping) {
                item.addPage(player, folder, mappeditemstack);
            }
            player.field_71071_by.func_70299_a(itemSlot, folder);
        }
    }

    @Nonnull
    public static ItemStack createItemstack(@Nonnull ItemStack prototype) {
        if (prototype.func_77973_b() == Items.field_151121_aF) {
            prototype.func_190918_g(1);
            return Page.createPage();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public String getDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack) {
        return this.func_77653_i(itemstack);
    }

    @Override
    public void setDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack, String name) {
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, @Nonnull ItemStack itemstack, ResourceLocation symbol2) {
        if (!Page.isBlank(itemstack)) {
            return false;
        }
        Page.setSymbol(itemstack, symbol2);
        return true;
    }

    @Override
    public List<ItemStack> getPageList(EntityPlayer player, @Nonnull ItemStack itemstack) {
        return Collections.singletonList(itemstack);
    }

    @Override
    @Nonnull
    public ItemStack onLoad(@Nonnull ItemStack itemstack) {
        ItemPage.remapItemstack(itemstack);
        return itemstack;
    }
}

