/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.data.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ItemInkVial
extends Item {
    public ItemInkVial() {
        this.func_77625_d(16);
        this.func_77655_b("myst.vial");
        this.func_77637_a(MystcraftCommonProxy.tabMystCommon);
        this.func_77642_a(Items.field_151069_bo);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new InkVialFluidHandler(stack);
    }

    public static class InkVialFluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nonnull
        private ItemStack container;

        InkVialFluidHandler(@Nonnull ItemStack container) {
            this.container = container;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        @Nullable
        Fluid getContainedFluid() {
            if (this.container.func_190926_b() || !this.container.func_77973_b().equals((Object)ModItems.inkvial)) {
                return null;
            }
            return ModFluids.black_ink;
        }

        @Nullable
        public FluidStack getFluid() {
            if (this.getContainedFluid() == null) {
                return null;
            }
            return new FluidStack(this.getContainedFluid(), 1000);
        }

        void setFluid(@Nullable Fluid f) {
            this.container = f == null ? new ItemStack(Items.field_151069_bo) : new ItemStack((Item)ModItems.inkvial);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000 || this.container.func_77973_b() instanceof ItemInkVial || this.getFluid() != null || resource.getFluid() != ModFluids.black_ink) {
                return 0;
            }
            if (doFill) {
                this.setFluid(resource.getFluid());
            }
            return 1000;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount < 1000) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
                if (doDrain) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < 1000) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null) {
                if (doDrain) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return null;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
            }
            return null;
        }
    }
}

