/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class InventoryFolder {
    public static boolean isItemValid(@Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return true;
        }
        if (itemstack.func_190916_E() != 1) {
            return false;
        }
        if (itemstack.func_77973_b() == ModItems.page) {
            return true;
        }
        return itemstack.func_77973_b() == Items.field_151121_aF;
    }

    private static void initFolder(@Nonnull ItemStack folder) {
        if (folder.func_77978_p() == null) {
            folder.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setName(@Nonnull ItemStack folder, String bookname) {
        if (folder.func_190926_b()) {
            return;
        }
        if (!folder.func_77973_b().equals(ModItems.folder)) {
            return;
        }
        if (folder.func_77978_p() == null) {
            InventoryFolder.initFolder(folder);
        }
        if (bookname == null || bookname.equals("")) {
            folder.func_77978_p().func_82580_o("Name");
        } else {
            folder.func_77978_p().func_74778_a("Name", bookname);
        }
    }

    @Nullable
    public static String getName(@Nonnull ItemStack folder) {
        if (folder.func_190926_b()) {
            return null;
        }
        if (!folder.func_77973_b().equals(ModItems.folder)) {
            return null;
        }
        if (folder.func_77978_p() == null) {
            InventoryFolder.initFolder(folder);
        }
        if (!folder.func_77978_p().func_74764_b("Name")) {
            return null;
        }
        return folder.func_77978_p().func_74779_i("Name");
    }

    @Nullable
    private static NBTTagCompound getInventoryCompound(@Nonnull ItemStack folder) {
        if (folder.func_190926_b()) {
            return null;
        }
        if (!folder.func_77973_b().equals(ModItems.folder)) {
            return null;
        }
        if (folder.func_77978_p() == null) {
            InventoryFolder.initFolder(folder);
        }
        if (!folder.func_77978_p().func_74764_b("Pages")) {
            folder.func_77978_p().func_74782_a("Pages", (NBTBase)new NBTTagCompound());
        }
        return folder.func_77978_p().func_74775_l("Pages");
    }

    public static int getItemCount(@Nonnull ItemStack folder) {
        if (InventoryFolder.getInventoryCompound(folder) == null) {
            return 0;
        }
        return InventoryFolder.getInventoryCompound(folder).func_150296_c().size();
    }

    public static int getLargestSlotId(@Nonnull ItemStack folder) {
        int largest = -1;
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return 0;
        }
        for (String tagname : compound.func_150296_c()) {
            int slot = Integer.parseInt(tagname);
            if (largest >= slot) continue;
            largest = slot;
        }
        return largest;
    }

    @Nonnull
    public static ItemStack getItem(@Nonnull ItemStack folder, int slot) {
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data != null && data.func_74764_b(String.valueOf(slot))) {
            return new ItemStack(data.func_74775_l(String.valueOf(slot)));
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack setItem(@Nonnull ItemStack folder, int slot, @Nonnull ItemStack page) {
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data == null) {
            return page;
        }
        ItemStack split = page.func_77979_a(1);
        if (!InventoryFolder.isItemValid(split)) {
            page.func_190917_f(1);
            return page;
        }
        ItemStack previous = InventoryFolder.removeItem(folder, slot);
        if (page.func_190916_E() > 0) {
            if (!previous.func_190926_b()) {
                page.func_190917_f(1);
                return page;
            }
            previous = page;
        }
        if (!split.func_190926_b() && split.func_190916_E() > 0) {
            data.func_74782_a(String.valueOf(slot), (NBTBase)split.func_77955_b(new NBTTagCompound()));
        } else {
            data.func_82580_o(String.valueOf(slot));
        }
        return previous;
    }

    @Nonnull
    public static ItemStack removeItem(@Nonnull ItemStack folder, int slot) {
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        ItemStack itemstack = ItemStack.field_190927_a;
        String strSlot = String.valueOf(slot);
        if (data != null) {
            if (data.func_74764_b(strSlot)) {
                itemstack = new ItemStack(data.func_74775_l(strSlot));
            }
            data.func_82580_o(strSlot);
        }
        return itemstack;
    }

    @Nonnull
    public static ItemStack addItem(@Nonnull ItemStack folder, @Nonnull ItemStack page) {
        if (!InventoryFolder.isItemValid(page)) {
            return page;
        }
        NBTTagCompound data = InventoryFolder.getInventoryCompound(folder);
        if (data == null) {
            return page;
        }
        int slot = 0;
        while (!page.func_190926_b()) {
            if (!data.func_74764_b(String.valueOf(slot))) {
                ItemStack clone = page.func_77946_l();
                clone.func_190920_e(1);
                data.func_74782_a(String.valueOf(slot), (NBTBase)clone.func_77955_b(new NBTTagCompound()));
                page.func_190918_g(1);
                if (page.func_190916_E() <= 0) {
                    page = ItemStack.field_190927_a;
                }
            }
            ++slot;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getItems(@Nonnull ItemStack folder) {
        ArrayList<ItemStack> pages = new ArrayList<ItemStack>();
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return pages;
        }
        for (String tagname : compound.func_150296_c()) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            int slot = Integer.parseInt(tagname);
            while (pages.size() <= slot) {
                pages.add(ItemStack.field_190927_a);
            }
            pages.set(slot, new ItemStack(pagedata));
        }
        return pages;
    }

    public static void updatePages(@Nonnull ItemStack folder) {
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(folder);
        if (compound == null) {
            return;
        }
        ArrayList tagnames = new ArrayList();
        tagnames.addAll(compound.func_150296_c());
        for (String tagname : tagnames) {
            NBTTagCompound pagedata = compound.func_74775_l(tagname);
            ItemStack page = new ItemStack(pagedata);
            List<ItemStack> results = SymbolRemappings.remap(page);
            int slot = Integer.parseInt(tagname);
            if (results.size() == 0) {
                InventoryFolder.removeItem(folder, slot);
                continue;
            }
            if (results.size() == 1) {
                InventoryFolder.setItem(folder, slot, results.get(0));
            }
            if (results.size() == 1) continue;
            InventoryFolder.removeItem(folder, slot);
            for (ItemStack item : results) {
                InventoryFolder.addItem(folder, item);
            }
        }
    }

    public static boolean writeSymbol(@Nonnull ItemStack folder, ResourceLocation symbol2) {
        List<ItemStack> pages = InventoryFolder.getItems(folder);
        for (ItemStack page : pages) {
            if (page.func_190926_b() || page.func_77973_b() != ModItems.page || !InternalAPI.page.isPageWritable(page)) continue;
            InternalAPI.page.setPageSymbol(page, symbol2);
            return true;
        }
        return false;
    }

    public static boolean isEmpty(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (!stack.func_77973_b().equals(ModItems.folder)) {
            return true;
        }
        if (stack.func_77978_p() == null) {
            InventoryFolder.initFolder(stack);
        }
        if (stack.func_77978_p().func_74764_b("Name")) {
            return false;
        }
        NBTTagCompound compound = InventoryFolder.getInventoryCompound(stack);
        if (compound == null) {
            return true;
        }
        return InventoryFolder.getItemCount(stack) <= 0;
    }
}

