/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.inventory.SlotFiltered;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.TileEntityLinkModifier;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerLinkModifier
extends ContainerBase
implements IGuiMessageHandler {
    private TileEntityLinkModifier tileentity = null;
    private InventoryPlayer inventoryplayer;
    @Nonnull
    private String cached_title = "";
    private Boolean cached_deadlink = null;

    public ContainerLinkModifier(InventoryPlayer inventoryplayer, TileEntityLinkModifier tileentity) {
        this.tileentity = tileentity;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    public void updateSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        if (this.tileentity != null) {
            int i;
            this.func_75146_a((Slot)new SlotFiltered((IItemHandlerModifiable)this.tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN), this.tileentity, 0, 80, 35));
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new Slot((IInventory)this.inventoryplayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)this.inventoryplayer, i, 8 + i * 18, 142));
            }
        }
        this.collections.clear();
        SlotCollection internal = new SlotCollection(this, 0, 1);
        SlotCollection maininv = new SlotCollection(this, 1, 28);
        SlotCollection hotbar = new SlotCollection(this, 28, 37);
        internal.pushTargetFront(maininv);
        internal.pushTargetFront(hotbar);
        maininv.pushTargetFront(hotbar);
        maininv.pushTargetFront(internal);
        hotbar.pushTargetFront(maininv);
        hotbar.pushTargetFront(internal);
        this.collections.add(internal);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    public void func_75142_b() {
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            ItemStack actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            ItemStack stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual) || slotId != 0) continue;
            this.cached_deadlink = null;
        }
        super.func_75142_b();
        ArrayList<MPacketGuiMessage> packets = new ArrayList<MPacketGuiMessage>();
        if (this.cached_deadlink == null) {
            this.cached_deadlink = this.checkLinkDead();
            if (this.cached_deadlink != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74757_a("LinkDead", this.cached_deadlink.booleanValue());
                packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
            }
        }
        if (packets.size() > 0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                for (IMessage iMessage : packets) {
                    MystcraftPacketHandler.CHANNEL.sendTo(iMessage, (EntityPlayerMP)listener);
                }
            }
        }
    }

    @Override
    public void processMessage(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound data) {
        if (data.func_74764_b("LinkDead")) {
            this.cached_deadlink = data.func_74767_n("LinkDead");
        }
        if (data.func_74764_b("RecycleDim")) {
            this.tileentity.recycleDimension();
            this.cached_deadlink = null;
        }
        if (data.func_74764_b("SetFlag")) {
            this.tileentity.setLinkOption(data.func_74779_i("SetFlag"), data.func_74767_n("Value"));
        }
        if (data.func_74764_b("SetSeed")) {
            ItemStack book;
            String seedstr = data.func_74779_i("SetSeed");
            Long seed = null;
            if (seedstr.isEmpty()) {
                this.tileentity.setLinkProperty("Seed", null);
            } else {
                try {
                    seed = Long.parseLong(seedstr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (seed != null && !(book = this.tileentity.getBook()).func_190926_b() && book.func_77973_b() instanceof ItemAgebook) {
                ItemAgebook item = (ItemAgebook)this.tileentity.getBook().func_77973_b();
                item.setSeed(player, this.tileentity.getBook(), seed);
            }
        }
        if (data.func_74764_b("SetTitle")) {
            this.cached_title = data.func_74779_i("SetTitle");
            this.tileentity.setBookTitle(player, this.cached_title);
        }
    }

    public String getBookTitle() {
        String title = this.tileentity.getBookTitle();
        if (title == null) {
            title = "";
        }
        return title;
    }

    public boolean getLinkFlag(String id) {
        return this.tileentity.getLinkOption(id);
    }

    public String getLinkDimensionUID() {
        return this.tileentity.getLinkDimensionUID();
    }

    public String getItemSeed() {
        return this.tileentity.getLinkProperty("Seed");
    }

    public boolean isLinkDead() {
        ItemStack book = this.tileentity.getBook();
        if (book == null) {
            this.cached_deadlink = null;
        }
        if (this.cached_deadlink == null) {
            return false;
        }
        return this.cached_deadlink;
    }

    private boolean checkLinkDead() {
        return this.tileentity.isLinkDimensionDead();
    }

    public boolean hasItemSeed() {
        ItemStack book = this.tileentity.getBook();
        return !book.func_190926_b() && book.func_77973_b() instanceof ItemAgebook;
    }

    public static class Messages {
        public static final String SetTitle = "SetTitle";
        public static final String SetFlag = "SetFlag";
        public static final String SetSeed = "SetSeed";
        public static final String RecycleDim = "RecycleDim";
        public static final String LinkDead = "LinkDead";
    }
}

