/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.decay;

import com.xcompwiz.mystcraft.block.BlockDecay;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerBlack;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerBlue;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerPurple;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerRed;
import com.xcompwiz.mystcraft.instability.decay.DecayHandlerWhite;
import com.xcompwiz.mystcraft.world.WorldInfoUtils;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public abstract class DecayHandler {
    private static HashMap<DecayType, DecayHandler> handlers = new HashMap();
    private DecayType decayType;

    public static void registerHandler(DecayType type, DecayHandler handler) {
        handler.setDecayType(type);
        handlers.put(type, handler);
    }

    protected void setDecayType(DecayType type) {
        this.decayType = type;
    }

    protected DecayType getDecayType() {
        return this.decayType;
    }

    protected IBlockState getBlockState() {
        return ModBlocks.decay.func_176223_P().func_177226_a(BlockDecay.DECAY_META, (Comparable)((Object)this.getDecayType()));
    }

    public static DecayHandler getHandler(DecayType decayType) {
        return handlers.get((Object)decayType);
    }

    protected void addInstability(World world, int amount) {
    }

    public abstract String getIdentifier();

    public void onBlockAdded(World world, BlockPos pos) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() == ModBlocks.decay && !WorldInfoUtils.isMystcraftAge(world)) {
            world.func_175698_g(pos);
            return;
        }
    }

    public void updateTick(World world, BlockPos pos, Random random) {
        this.pulse(world, pos, random);
    }

    protected abstract void pulse(World var1, BlockPos var2, Random var3);

    public void onBlockDestroyedByPlayer(World world, BlockPos pos) {
    }

    public float getExplosionResistance(World worldObj, BlockPos pos, Entity exploder, Explosion explosion) {
        return 2.5f;
    }

    public float getBlockHardness(World worldObj, BlockPos pos) {
        return 0.5f;
    }

    public void onEntityContact(World worldObj, BlockPos pos, Entity entity) {
    }

    static {
        DecayHandler.registerHandler(DecayType.BLACK, new DecayHandlerBlack());
        DecayHandler.registerHandler(DecayType.RED, new DecayHandlerRed());
        DecayHandler.registerHandler(DecayType.BLUE, new DecayHandlerBlue());
        DecayHandler.registerHandler(DecayType.PURPLE, new DecayHandlerPurple());
        DecayHandler.registerHandler(DecayType.WHITE, new DecayHandlerWhite());
    }

    public static enum DecayType implements IStringSerializable
    {
        BLACK(0, "black"),
        RED(1, "red"),
        GREEN(2, "green"),
        BLUE(3, "blue"),
        PURPLE(4, "purple"),
        YELLOW(5, "yellow"),
        WHITE(6, "white");

        private final int index;
        private final String name;

        private DecayType(int indexIn, String nameIn) {
            this.index = indexIn;
            this.name = nameIn;
        }

        public int getIndex() {
            return this.index;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

