/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.explosion;

import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffect;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectBasic;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectBreakBlocks;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectFire;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectPlaceOres;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionAdvanced {
    private int size = 16;
    private Random explosionRNG = new Random();
    private World worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float explosionSize;
    public List<BlockPos> blocks = new ArrayList<BlockPos>();
    public List<ExplosionEffect> effects = new ArrayList<ExplosionEffect>();
    private Map<Entity, Vec3d> players = new HashMap<Entity, Vec3d>();
    private Explosion mcExplosionDummy;
    private static HashMap<Byte, ExplosionEffect> effectmap = new HashMap();
    private static HashMap<ExplosionEffect, Byte> effectid = new HashMap();
    private static byte nextId = 0;

    public static void registerEffect(ExplosionEffect effect) {
        if (effectmap.containsKey(nextId)) {
            throw new RuntimeException("Mystcraft has run out of explosion effect IDs!  Contact XCompWiz and ask for more!");
        }
        effectmap.put(nextId, effect);
        byte by = nextId;
        nextId = (byte)(by + 1);
        effectid.put(effect, by);
    }

    public static ExplosionEffect getEffectById(byte id) {
        return effectmap.get(id);
    }

    public static byte getEffectId(ExplosionEffect effect) {
        return effectid.get(effect);
    }

    public ExplosionAdvanced(World worldObj, Entity entity, double x, double y, double z, float size) {
        this.worldObj = worldObj;
        this.exploder = entity;
        this.explosionSize = size;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
    }

    public void doExplosionA() {
        float explosionSize = this.explosionSize;
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                for (int z = 0; z < this.size; ++z) {
                    if (x != 0 && x != this.size - 1 && y != 0 && y != this.size - 1 && z != 0 && z != this.size - 1) continue;
                    double dx = (float)x / ((float)this.size - 1.0f) * 2.0f - 1.0f;
                    double dy = (float)y / ((float)this.size - 1.0f) * 2.0f - 1.0f;
                    double dz = (float)z / ((float)this.size - 1.0f) * 2.0f - 1.0f;
                    double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx /= length;
                    dy /= length;
                    dz /= length;
                    double posX = this.explosionX;
                    double posY = this.explosionY;
                    double posZ = this.explosionZ;
                    float factor = 0.3f;
                    for (float power = explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); power > 0.0f; power -= factor * 0.75f) {
                        int blockZ;
                        int blockY;
                        int blockX = MathHelper.func_76128_c((double)posX);
                        BlockPos blockPos = new BlockPos(blockX, blockY = MathHelper.func_76128_c((double)posY), blockZ = MathHelper.func_76128_c((double)posZ));
                        IBlockState block = this.worldObj.func_180495_p(blockPos);
                        if ((power -= (block.func_177230_c().getExplosionResistance(this.worldObj, blockPos, this.exploder, this.toExplosion()) + 0.3f) * factor) > 0.0f) {
                            blocks.add(new BlockPos(blockX, blockY, blockZ));
                        }
                        posX += dx * (double)factor;
                        posY += dy * (double)factor;
                        posZ += dz * (double)factor;
                    }
                }
            }
        }
        this.blocks.addAll(blocks);
        if (this.mcExplosionDummy != null) {
            this.mcExplosionDummy.func_180343_e().addAll(blocks);
        }
        int minX = MathHelper.func_76128_c((double)(this.explosionX - (double)(explosionSize *= 2.0f) - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.explosionX + (double)explosionSize + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.explosionY - (double)explosionSize - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.explosionY + (double)explosionSize + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.explosionZ - (double)explosionSize - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.explosionZ + (double)explosionSize + 1.0));
        List entities = this.worldObj.func_72839_b(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3d explosionVec = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : entities) {
            double dz;
            double dy;
            double dx;
            double length;
            double dist = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)explosionSize;
            if (!(dist < 1.0) || (length = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.explosionX) * dx + (dy = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * dy + (dz = entity.field_70161_v - this.explosionZ) * dz))) == 0.0) continue;
            dx /= length;
            dy /= length;
            dz /= length;
            double reduction = this.worldObj.func_72842_a(explosionVec, entity.func_174813_aQ());
            double force = (1.0 - dist) * reduction;
            entity.func_70097_a(ExplosionAdvanced.getDamageSource(this), (float)((int)((force * force + force) / 2.0 * 8.0 * (double)explosionSize + 1.0)));
            entity.field_70159_w += dx * force;
            entity.field_70181_x += dy * force;
            entity.field_70179_y += dz * force;
            if (!(entity instanceof EntityPlayer)) continue;
            this.players.put(entity, new Vec3d(dx * force, dy * force, dz * force));
        }
    }

    public static DamageSource getDamageSource(ExplosionAdvanced explosion) {
        return explosion != null && explosion.exploder != null ? new EntityDamageSource("explosion.player", explosion.exploder).func_76351_m().func_94540_d() : DamageSource.func_94539_a((Explosion)null);
    }

    public void doExplosionB(boolean isClient) {
        this.worldObj.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0, new int[0]);
        for (BlockPos pos : this.blocks) {
            for (ExplosionEffect effect : this.effects) {
                effect.apply(this.worldObj, this, pos, this.explosionRNG, isClient);
            }
        }
    }

    public Map<Entity, Vec3d> getPlayerMap() {
        return this.players;
    }

    public Explosion toExplosion() {
        if (this.mcExplosionDummy == null) {
            this.mcExplosionDummy = new Explosion(this.worldObj, this.exploder, this.explosionX, this.explosionY, this.explosionZ, this.explosionSize, false, true);
            this.mcExplosionDummy.func_180343_e().addAll(this.blocks);
        }
        return this.mcExplosionDummy;
    }

    static {
        ExplosionAdvanced.registerEffect(ExplosionEffectBasic.instance);
        ExplosionAdvanced.registerEffect(ExplosionEffectBreakBlocks.dropItems);
        ExplosionAdvanced.registerEffect(ExplosionEffectBreakBlocks.noDrop);
        ExplosionAdvanced.registerEffect(ExplosionEffectFire.instance);
        ExplosionAdvanced.registerEffect(ExplosionEffectPlaceOres.instance);
    }
}

