/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModSymbols;
import com.xcompwiz.mystcraft.data.ModSymbolsFluids;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRegistryPrimer {
    public static ModRegistryPrimer INSTANCE = new ModRegistryPrimer();
    private Map<Class<?>, List<IForgeRegistryEntry<?>>> bufferedRegistry = new HashMap();

    private ModRegistryPrimer() {
    }

    public static void queueForRegistration(IForgeRegistryEntry<?> entry) {
        Class registryType = entry.getRegistryType();
        ModRegistryPrimer.INSTANCE.bufferedRegistry.computeIfAbsent(registryType, k -> new LinkedList()).add(entry);
    }

    private <V extends IForgeRegistryEntry<V>> void addToRegistry(IForgeRegistry<V> registry) {
        List<IForgeRegistryEntry<?>> entries = this.bufferedRegistry.get(registry.getRegistrySuperType());
        if (entries != null) {
            for (IForgeRegistryEntry<?> entry : entries) {
                registry.register(entry);
            }
        }
    }

    @SubscribeEvent
    public void onRegistrySymbols(RegistryEvent.Register<IAgeSymbol> event) {
        this.addToRegistry(event.getRegistry());
    }

    @SubscribeEvent
    public void onRegistryEventBlocks(RegistryEvent.Register<Block> event) {
        this.addToRegistry(event.getRegistry());
    }

    @SubscribeEvent
    public void onRegistryEventItems(RegistryEvent.Register<Item> event) {
        this.addToRegistry(event.getRegistry());
    }

    @SubscribeEvent
    public void onRegistryEventRecipes(RegistryEvent.Register<IRecipe> event) {
        this.addToRegistry(event.getRegistry());
    }

    @SubscribeEvent
    public void onRegistryEventSounds(RegistryEvent.Register<SoundEvent> event) {
        this.addToRegistry(event.getRegistry());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRegistryBiomes(RegistryEvent.Register<Biome> event) {
        ModSymbols.generateBiomeSymbols();
        ModSymbolsFluids.modsLoaded();
    }
}

