/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.linkeffects;

import com.xcompwiz.mystcraft.api.client.ILinkPanelEffect;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LinkRendererDisarm
implements ILinkPanelEffect {
    private Random rand = new Random();
    private long lasttime;
    private Point effect;

    @Override
    public void onOpen() {
        this.lasttime = System.currentTimeMillis();
    }

    @Override
    public void render(int i, int j, int k, int l, ILinkInfo linkInfo, @Nonnull ItemStack bookclone) {
        if (linkInfo.getFlag("Disarm")) {
            long now = System.currentTimeMillis();
            long delta = now - this.lasttime;
            if (delta > 3000L && this.rand.nextInt(3000) == 0 || delta > 8000L) {
                this.generateLightningEffect(i, j, k, l);
                this.lasttime = now;
                delta = 0L;
            }
            if (this.effect != null) {
                this.effect.drawLightning();
                if (delta > 300L) {
                    this.effect = null;
                }
            }
        }
    }

    private void generateLightningEffect(int left, int top, int sizex, int sizey) {
        this.effect = this.generateCenterPoint(left, top, sizex, sizey);
        int offset = this.rand.nextInt(4);
        for (int i = 0; i < this.rand.nextInt(6) + 3; ++i) {
            this.effect.addChild(this.generateEndPoint((i + offset) % 4, left, top, sizex, sizey));
        }
    }

    private Point generateCenterPoint(int left, int top, int sizex, int sizey) {
        return new Point(this.rand.nextInt(sizex / 2) + left + sizex / 4, this.rand.nextInt(sizey / 2) + top + sizey / 4);
    }

    private Point generateEndPoint(int side, int left, int top, int sizex, int sizey) {
        switch (side) {
            case 0: {
                return new Point(left, this.rand.nextInt(sizey) + top);
            }
            case 1: {
                return new Point(this.rand.nextInt(sizex) + left, top);
            }
            case 2: {
                return new Point(sizex + left, this.rand.nextInt(sizey) + top);
            }
            case 3: {
                return new Point(this.rand.nextInt(sizex) + left, sizey + top);
            }
        }
        return new Point(this.rand.nextInt(sizex) + left, this.rand.nextInt(sizey) + top);
    }

    public class Point {
        private int x;
        private int y;
        private ArrayList<Point> children;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void addChild(Point child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        public void drawLightning() {
            double x = (double)this.x + LinkRendererDisarm.this.rand.nextGaussian() * 2.0;
            double y = (double)this.y + LinkRendererDisarm.this.rand.nextGaussian() * 2.0;
            for (Point p : this.children) {
                this.drawLine(x, y, (double)p.x + LinkRendererDisarm.this.rand.nextGaussian() * 3.0, (double)p.y + LinkRendererDisarm.this.rand.nextGaussian() * 3.0);
            }
        }

        private double interpolate(double start, double end, float f) {
            return start + (end - start) * (double)f;
        }

        private void drawLine(double par1, double par2, double par3, double par4) {
            double factor;
            int i;
            int color = -52429;
            int points = LinkRendererDisarm.this.rand.nextInt(50);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179103_j((int)7425);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            long seed = LinkRendererDisarm.this.rand.nextLong();
            Random lrand = new Random();
            lrand.setSeed(seed);
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            GlStateManager.func_187441_d((float)8.0f);
            vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(par1, par2, 0.0).func_181675_d();
            for (i = 1; i < points; ++i) {
                factor = 2 * (1 - i / points);
                vb.func_181662_b(this.interpolate(par1, par3, (float)i / (float)points) + lrand.nextGaussian() * factor, this.interpolate(par2, par4, (float)i / (float)points) + lrand.nextGaussian() * factor, 0.0).func_181675_d();
            }
            vb.func_181662_b(par3, par4, 0.0);
            tes.func_78381_a();
            lrand.setSeed(seed);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187441_d((float)2.0f);
            vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(par1, par2, 0.0).func_181675_d();
            for (i = 1; i < points; ++i) {
                factor = 2 * (1 - i / points);
                vb.func_181662_b(this.interpolate(par1, par3, (float)i / (float)points) + lrand.nextGaussian() * factor, this.interpolate(par2, par4, (float)i / (float)points) + lrand.nextGaussian() * factor, 0.0).func_181675_d();
            }
            vb.func_181662_b(par3, par4, 0.0).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
        }
    }
}

