/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButton;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementIcon;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementLabel;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementPanel;
import com.xcompwiz.mystcraft.client.gui.element.data.GuiIconItemStack;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiElementShopItem
extends GuiElement
implements GuiElementButton.IGuiOnClickHandler,
GuiElementLabel.IGuiLabelDataProvider,
GuiIconItemStack.IItemStackProvider {
    private IGuiShopHandler shop;
    private int id;

    public GuiElementShopItem(IGuiShopHandler shop, int id, int guiLeft, int guiTop, int xSize, int ySize) {
        super(guiLeft, guiTop, xSize, ySize);
        this.shop = shop;
        this.id = id;
        int buttonY = 10;
        int labelY = 10;
        int panelY = ySize - buttonY - labelY - labelY;
        float itemSizeX = xSize / 2;
        int paddingX = (int)((float)xSize - itemSizeX) / 2;
        int paddingY = (int)((float)panelY - itemSizeX) / 2;
        GuiElementPanel panel = new GuiElementPanel(0, 0, xSize, panelY);
        panel.setBackground(-7829368, -12303292);
        this.addElement(panel);
        panel.addElement(new GuiElementIcon(new GuiIconItemStack(this, "itemstack"), paddingX, paddingY, (int)itemSizeX, (int)itemSizeX));
        this.addElement(new GuiElementLabel(this, "name", 0, ySize - buttonY - labelY - labelY, xSize, labelY, 0x7F000000, -2236963));
        this.addElement(new GuiElementLabel(this, "price", 0, ySize - buttonY - labelY, xSize - labelY, labelY, 0x7F000000, -7798904));
        this.addElement(new GuiElementIcon(new GuiIconItemStack(new ItemStack(Items.field_151166_bC)), xSize - labelY, ySize - buttonY - labelY, labelY, labelY));
        this.addElement(this.createButton(this, "Buy", 0, ySize - buttonY, xSize, buttonY));
    }

    private GuiElement createButton(GuiElementButton.IGuiOnClickHandler eventhandler, String id, int guiLeft, int guiTop, int width, int height) {
        GuiElementButton button = new GuiElementButton(eventhandler, id, guiLeft, guiTop, width, height);
        button.setText(id);
        return button;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void onClick(GuiElementButton caller) {
        if (caller.getId().equals("Buy")) {
            this.shop.onPurchase(this);
        }
    }

    @Override
    public String getText(GuiElementLabel caller) {
        if (caller.getId().equals("price")) {
            return this.shop.getPriceText(this);
        }
        if (caller.getId().equals("name")) {
            ItemStack itemstack = this.shop.getItemstack(this);
            if (itemstack.func_190926_b()) {
                return "";
            }
            if (itemstack.func_77973_b() instanceof ItemPage) {
                ResourceLocation symbolId = Page.getSymbol(itemstack);
                IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(symbolId);
                if (symbol2 == null) {
                    return "Unknown: " + symbolId;
                }
                return symbol2.getLocalizedName();
            }
            return itemstack.func_82833_r();
        }
        return "???";
    }

    @Override
    public List<String> getTooltip(GuiElementLabel caller) {
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack(GuiIconItemStack caller) {
        return this.shop.getItemstack(this);
    }

    public static interface IGuiShopHandler {
        public void onPurchase(GuiElementShopItem var1);

        public String getPriceText(GuiElementShopItem var1);

        @Nonnull
        public ItemStack getItemstack(GuiElementShopItem var1);
    }
}

