/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.data.IGuiIcon;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public abstract class GuiElementButtonBase
extends GuiElement {
    private IGuiIcon icon;
    private String text;
    private List<String> tooltip;
    private boolean clicked;
    private boolean hovered = false;
    public Color color = Color.WHITE;

    public GuiElementButtonBase(int guiLeft, int guiTop, int width, int height) {
        super(guiLeft, guiTop, width, height);
    }

    public void setIcon(IGuiIcon icon) {
        this.icon = icon;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTooltip(List<String> string) {
        this.tooltip = string;
    }

    @Override
    public boolean _onMouseUp(int mouseX, int mouseY, int button) {
        if (this.clicked && this.contains(mouseX, mouseY)) {
            this.onClick(mouseX, mouseY, button);
            this.clicked = false;
            return true;
        }
        this.clicked = false;
        return false;
    }

    protected abstract void onClick(int var1, int var2, int var3);

    protected boolean isDepressed() {
        return this.clicked;
    }

    @Override
    public boolean _onMouseDown(int mouseX, int mouseY, int button) {
        if (this.contains(mouseX, mouseY)) {
            this.clicked = true;
            return true;
        }
        return false;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovered) {
            return this.tooltip;
        }
        return super._getTooltipInfo();
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int fontcolor;
        this.hovered = this.contains(mouseX, mouseY);
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        float colorFactor = 1.0f;
        if (!this.isEnabled()) {
            fontcolor = -13421773;
            colorFactor = 0.5f;
        } else {
            fontcolor = -16777216;
        }
        GlStateManager.func_179131_c((float)(colorFactor * (float)this.color.getRed()), (float)(colorFactor * (float)this.color.getBlue()), (float)(colorFactor * (float)this.color.getGreen()), (float)this.color.getAlpha());
        if (this.xSize != this.ySize) {
            int color1 = -13158601;
            int color2 = -1;
            if (this.isDepressed()) {
                int temp = color1;
                color1 = color2;
                color2 = temp;
            }
            int innercolor = -7631989;
            GuiElementButtonBase.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + this.xSize), (int)(guiTop + this.ySize), (int)innercolor);
            GuiElementButtonBase.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + this.xSize - 1), (int)(guiTop + this.ySize - 1), (int)color2);
            GuiElementButtonBase.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + this.xSize), (int)(guiTop + this.ySize), (int)color1);
            GuiElementButtonBase.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + this.xSize - 1), (int)(guiTop + this.ySize - 1), (int)innercolor);
        } else if (this.isDepressed()) {
            GuiUtils.drawSprite(guiLeft, guiTop, this.xSize, this.ySize, 0, 0, this.getZLevel());
        } else {
            GuiUtils.drawSprite(guiLeft, guiTop, this.xSize, this.ySize, 0, 18, this.getZLevel());
        }
        if (this.hovered) {
            GuiUtils.drawGradientRect(guiLeft, guiTop, guiLeft + this.xSize, guiTop + this.ySize, -1862270977, -1862270977, this.getZLevel());
        }
        if (this.icon != null) {
            this.icon.render(this.mc, guiLeft, guiTop, this.xSize, this.ySize, this.getZLevel());
        }
        if (this.text != null) {
            GlStateManager.func_179097_i();
            GuiUtils.drawScaledText(this.text, guiLeft + 2, guiTop + 2, this.xSize - 4, this.ySize - 4, fontcolor);
            GlStateManager.func_179126_j();
        }
    }
}

