/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.block;

import com.xcompwiz.mystcraft.block.BlockBookDisplay;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBookstand
extends BlockBookDisplay {
    public static final PropertyInteger ROTATION_INDEX = PropertyInteger.func_177719_a((String)"rotindex", (int)0, (int)7);
    private static float[][] boxes = new float[3][6];

    public BlockBookstand() {
        super(Material.field_151575_d);
        this.func_149713_g(0);
        this.field_149783_u = true;
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("myst.bookstand");
        this.func_149647_a(MystcraftCommonProxy.tabMystCommon);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION_INDEX);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION_INDEX, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)7)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_INDEX});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult[] hits = new RayTraceResult[boxes.length];
        RayTraceResult hit = null;
        for (int i = 0; i < boxes.length; ++i) {
            float[] box = boxes[i];
            hits[i] = super.func_185503_a(pos, start, end, new AxisAlignedBB((double)box[0], (double)box[1], (double)box[2], (double)box[3], (double)box[4], (double)box[5]));
        }
        double farthest = 0.0;
        for (int i = 0; i < hits.length; ++i) {
            double dst;
            RayTraceResult c = hits[i];
            if (c == null || !((dst = c.field_72307_f.func_72436_e(end)) > farthest)) continue;
            hit = c;
            farthest = dst;
        }
        return hit;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rot = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
        return this.func_176203_a(rot);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBookstand();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityBookstand();
    }

    static {
        BlockBookstand.boxes[0] = new float[]{0.35f, 0.0f, 0.35f, 0.65f, 0.2f, 0.65f};
        BlockBookstand.boxes[1] = new float[]{0.45f, 0.1f, 0.45f, 0.55f, 0.5f, 0.45f};
        BlockBookstand.boxes[2] = new float[]{0.15f, 0.4f, 0.15f, 0.85f, 0.7f, 0.85f};
    }
}

