/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.symbol;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;

public final class ModifierUtils {
    public static final String ANGLE = "angle";
    public static final String PHASE = "phase";
    public static final String FACTOR = "wavelength";
    public static final String COLOR = "color";
    public static final String GRADIENT = "gradient";
    public static final String SUNSET = "sunset";
    public static final int dangling_block = 50;
    public static final int dangling_biome = 100;

    public static float averageLengths(float l, float r) {
        return (l + r) / 2.0f;
    }

    public static Color averageColors(Color left, Color right) {
        return left.average(right);
    }

    public static Color averageColors(Color color, float r, float g, float b) {
        return color.average(r, g, b);
    }

    public static float averageAngles(float first, float second) {
        float average;
        float third = second;
        if (Math.abs(first - second) > 180.0f) {
            third += 360.0f;
        }
        if (Math.abs(first - third) == 180.0f) {
            third = first + 180.0f;
        }
        if ((average = (first + third) / 2.0f) >= 360.0f) {
            average -= 360.0f;
        }
        return average;
    }

    public static float midPointOnArc(float first, float second) {
        float value = ((first %= 360.0f) + (second %= 360.0f)) / 2.0f;
        if (first > second) {
            value += 180.0f;
            value %= 360.0f;
        }
        return value;
    }

    public static ColorGradient popGradient(AgeDirector controller) {
        ColorGradient gradient = controller.popModifier(GRADIENT).asGradient();
        if (gradient == null) {
            gradient = new ColorGradient();
        }
        if (gradient.getColorCount() == 0) {
            gradient.pushColor(controller.popModifier(COLOR).asColor());
        }
        return gradient;
    }

    public static ColorGradient popGradient(AgeDirector controller, float r, float g, float b) {
        ColorGradient gradient = ModifierUtils.popGradient(controller);
        if (gradient.getColorCount() == 0) {
            gradient.pushColor(new Color(r, g, b));
        }
        return gradient;
    }

    @Deprecated
    public static BlockDescriptor popBlockOfType(AgeDirector controller, BlockCategory type) {
        return ModifierUtils.popBlockMatching(controller, type);
    }

    public static BlockDescriptor popBlockMatching(AgeDirector controller, BlockCategory ... types) {
        Modifier modifier = controller.popModifier("blocklist");
        List list = modifier.asList();
        if (list == null) {
            return null;
        }
        controller.setModifier("blocklist", modifier);
        for (int i = 0; i < list.size(); ++i) {
            BlockDescriptor block = (BlockDescriptor)list.get(i);
            for (BlockCategory type : types) {
                if (!block.isUsable(type)) continue;
                list.remove(i);
                modifier.dangling -= 50;
                return block;
            }
        }
        return null;
    }

    public static void pushBlock(AgeDirector controller, BlockDescriptor block) {
        Modifier modifier = controller.popModifier("blocklist");
        List list = modifier.asList();
        if (list == null) {
            list = new ArrayList();
            modifier = new Modifier(list, 0);
        }
        list.add(0, block);
        modifier.dangling += 50;
        controller.setModifier("blocklist", modifier);
    }

    public static void pushBiome(AgeDirector controller, Biome biome) {
        Modifier modifier = controller.popModifier("biomelist");
        List list = modifier.asList();
        if (list == null) {
            list = new ArrayList();
            modifier = new Modifier(list, 0);
        }
        list.add(biome);
        modifier.dangling += 100;
        controller.setModifier("biomelist", modifier);
    }

    public static Biome popBiome(AgeDirector controller) {
        Modifier modifier = controller.popModifier("biomelist");
        List list = modifier.asList();
        if (list == null || list.size() == 0) {
            return null;
        }
        controller.setModifier("biomelist", modifier);
        Biome biome = (Biome)list.remove(list.size() - 1);
        modifier.dangling -= 100;
        return biome;
    }
}

