/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft;

import com.google.common.collect.ImmutableList;
import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.command.CommandCreateAgebook;
import com.xcompwiz.mystcraft.command.CommandCreateDim;
import com.xcompwiz.mystcraft.command.CommandDebug;
import com.xcompwiz.mystcraft.command.CommandMystPermissions;
import com.xcompwiz.mystcraft.command.CommandRegenerateChunk;
import com.xcompwiz.mystcraft.command.CommandReprofile;
import com.xcompwiz.mystcraft.command.CommandSpawnMeteor;
import com.xcompwiz.mystcraft.command.CommandTPX;
import com.xcompwiz.mystcraft.command.CommandTime;
import com.xcompwiz.mystcraft.command.CommandToggleDownfall;
import com.xcompwiz.mystcraft.command.CommandToggleWorldInstability;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.core.MystcraftEventHandler;
import com.xcompwiz.mystcraft.core.MystcraftTickHandler;
import com.xcompwiz.mystcraft.core.TaskQueueManager;
import com.xcompwiz.mystcraft.data.GrammarRules;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.data.ModRecipes;
import com.xcompwiz.mystcraft.data.ModRegistryPrimer;
import com.xcompwiz.mystcraft.data.ModSounds;
import com.xcompwiz.mystcraft.data.ModSymbols;
import com.xcompwiz.mystcraft.data.ModSymbolsFluids;
import com.xcompwiz.mystcraft.data.ModWords;
import com.xcompwiz.mystcraft.data.SymbolRules;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.entity.EntityMeteor;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.instability.InstabilityData;
import com.xcompwiz.mystcraft.instability.InstabilityManager;
import com.xcompwiz.mystcraft.instability.bonus.EventManager;
import com.xcompwiz.mystcraft.inventory.GuiHandler;
import com.xcompwiz.mystcraft.linking.LinkListenerBasic;
import com.xcompwiz.mystcraft.linking.LinkListenerEffects;
import com.xcompwiz.mystcraft.linking.LinkListenerForgeServer;
import com.xcompwiz.mystcraft.linking.LinkListenerPermissions;
import com.xcompwiz.mystcraft.network.MystcraftConnectionHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookBinder;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookReceptacle;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.tileentity.TileEntityLinkModifier;
import com.xcompwiz.mystcraft.tileentity.TileEntityStarFissure;
import com.xcompwiz.mystcraft.treasure.LootTableHandler;
import com.xcompwiz.mystcraft.utility.ReflectionUtil;
import com.xcompwiz.mystcraft.villager.MerchantRecipeProviderItem;
import com.xcompwiz.mystcraft.villager.VillageCreationHandlerArchivistHouse;
import com.xcompwiz.mystcraft.villager.VillagerArchivist;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.gen.structure.ComponentScatteredFeatureSmallLibrary;
import com.xcompwiz.mystcraft.world.gen.structure.ComponentVillageArchivistHouse;
import com.xcompwiz.mystcraft.world.gen.structure.MapGenScatteredFeatureMyst;
import com.xcompwiz.mystcraft.world.gen.structure.StructureScatteredFeatureStartMyst;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import com.xcompwiz.mystcraft.world.profiling.MystWorldGenerator;
import com.xcompwiz.mystcraft.world.storage.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="mystcraft", version="0.13.7.04", name="Mystcraft", dependencies="required-after:forge@[14.23.5.2770,)", acceptedMinecraftVersions="[1.12]")
public class Mystcraft {
    @Mod.Instance(value="mystcraft")
    public static Mystcraft instance;
    @SidedProxy(clientSide="com.xcompwiz.mystcraft.client.MystcraftClientProxy", serverSide="com.xcompwiz.mystcraft.core.MystcraftCommonProxy")
    public static MystcraftCommonProxy sidedProxy;
    public static int difficulty;
    public static boolean instabilityEnabled;
    public static boolean renderlabels;
    public static boolean fastRainbows;
    private static boolean spawnmeteorEnabled;
    public static boolean respawnInAges;
    public static boolean villageDeskGen;
    public static boolean serverLabels;
    public static int providerId;
    public static DimensionType dimensionType;
    public static Collection<Integer> registeredDims;
    public static LinkedList<Integer> deadDims;
    public static boolean archivistEnabled;
    public VillagerArchivist archivist;
    private ChunkProfilerManager profilingThread;
    public static int inkcost;
    public static Set<String> validInks;
    public static MapStorage clientStorage;
    public static boolean requireUUID;
    public static int homeDimension;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        InternalAPI.initAPI();
        MystcraftPacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new MystcraftConnectionHandler());
        MinecraftForge.EVENT_BUS.register((Object)ModRegistryPrimer.INSTANCE);
        SymbolManager.buildRegistry();
        ReflectionUtil.init();
        MinecraftForge.EVENT_BUS.register((Object)new MystcraftEventHandler());
        EventManager eventmanager = new EventManager();
        MinecraftForge.EVENT_BUS.register((Object)eventmanager);
        MinecraftForge.EVENT_BUS.register((Object)new MystcraftTickHandler());
        EventManager.set(eventmanager);
        File configroot = event.getSuggestedConfigurationFile().getParentFile();
        File configfile = new File(configroot, "mystcraft/core.cfg");
        File oldconfigfile = new File(configroot, "Mystcraft.txt");
        if (oldconfigfile.exists()) {
            configfile.getParentFile().mkdirs();
            if (!configfile.exists()) {
                oldconfigfile.renameTo(configfile);
            }
        }
        MystConfig config = new MystConfig(configfile);
        MystConfig balanceconfig = new MystConfig(new File(configroot, "mystcraft/balance.cfg"));
        SymbolManager.setConfig(new MystConfig(new File(configroot, "mystcraft/symbols.cfg")));
        InstabilityManager.setConfig(new MystConfig(new File(configroot, "mystcraft/instabilities.cfg")));
        ModSymbolsFluids.setConfig(balanceconfig);
        InstabilityDataCalculator.setBalanceConfig(balanceconfig);
        boolean generate_template = config.get("general", "configs.generate_template.balance", false).getBoolean(false);
        spawnmeteorEnabled = config.get("general", "commands.spawnmeteor.enabled", spawnmeteorEnabled).getBoolean(spawnmeteorEnabled);
        difficulty = balanceconfig.getOptional("instability", "global.difficulty", difficulty);
        instabilityEnabled = balanceconfig.get("instability", "global.enabled", instabilityEnabled).getBoolean(instabilityEnabled);
        renderlabels = config.get("render", "renderlabels", renderlabels, "If set to false on the server config, this will override client settings.").getBoolean(renderlabels);
        fastRainbows = config.get("render", "fast_rainbows", fastRainbows).getBoolean(fastRainbows);
        respawnInAges = config.get("general", "respawning.respawnInAges", respawnInAges).getBoolean(respawnInAges);
        villageDeskGen = config.get("general", "generation.villageDeskGen", villageDeskGen).getBoolean(villageDeskGen);
        requireUUID = config.get("general", "teleportation.requireUUIDTest", requireUUID, "If set to true, the dimension matching test will be strict. This will force new players to the \"home\" dimension.").getBoolean(requireUUID);
        homeDimension = config.get("general", "teleportation.homedim", homeDimension).getInt();
        archivistEnabled = config.get("general", "ids.villager.archivist", true).getBoolean();
        providerId = config.get("general", "ids.dim_provider", 1210950779).getInt();
        serverLabels = renderlabels;
        if (generate_template) {
            ModSymbolsFluids.setReferenceConfig(new MystConfig(new File(configroot, "mystcraft/balance_template.cfg")));
        }
        ModFluids.loadConfigs(config);
        ModItems.loadConfigs(config);
        ModBlocks.loadConfigs(config);
        ModRecipes.loadConfigs(config);
        ModLinkEffects.setConfigs(config);
        InstabilityDataCalculator.loadConfigs(config);
        if (config.hasChanged()) {
            config.save();
        }
        MapGenStructureIO.func_143034_b(StructureScatteredFeatureStartMyst.class, (String)MapGenScatteredFeatureMyst.stringId);
        MapGenStructureIO.func_143031_a(ComponentScatteredFeatureSmallLibrary.class, (String)"TeMystSL");
        MapGenStructureIO.func_143031_a(ComponentVillageArchivistHouse.class, (String)"ViMystAH");
        SymbolRemappings.initialize();
        GrammarRules.initialize();
        dimensionType = DimensionType.register((String)"Mystcraft", (String)"_myst", (int)providerId, WorldProviderMyst.class, (boolean)false);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new MystWorldGenerator(), (int)Integer.MAX_VALUE);
        sidedProxy.createCreativeTabs();
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerBasic());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerPermissions());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerEffects());
        MinecraftForge.EVENT_BUS.register((Object)new LinkListenerForgeServer());
        ModFluids.init();
        ModItems.init();
        ModBlocks.init();
        InkEffects.init();
        ModRecipes.addRecipes();
        ModSymbolsFluids.init();
        ModAchievements.init();
        ModSounds.init();
        sidedProxy.preinit();
        ModSymbols.initialize();
        ModWords.initialize();
        SymbolRules.initialize();
        InstabilityData.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"reccomplex", (String)"registerDimensionType", (String)"MYSTCRAFT_PROFILING");
        NBTTagCompound tagRegisterDimensionTypes = new NBTTagCompound();
        tagRegisterDimensionTypes.func_74768_a("dimensionID", Integer.MIN_VALUE);
        NBTTagList types = new NBTTagList();
        types.func_74742_a((NBTBase)new NBTTagString("MYSTCRAFT_PROFILING"));
        tagRegisterDimensionTypes.func_74782_a("types", (NBTBase)types);
        FMLInterModComms.sendMessage((String)"reccomplex", (String)"registerDimension", (NBTTagCompound)tagRegisterDimensionTypes);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileEntityLectern.class, (ResourceLocation)new ResourceLocation("mystcraft", "linkbook_lectern"));
        GameRegistry.registerTileEntity(TileEntityBookstand.class, (ResourceLocation)new ResourceLocation("mystcraft", "linkbook_stand"));
        GameRegistry.registerTileEntity(TileEntityStarFissure.class, (ResourceLocation)new ResourceLocation("mystcraft", "starfissure"));
        GameRegistry.registerTileEntity(TileEntityDesk.class, (ResourceLocation)new ResourceLocation("mystcraft", "writingdesk"));
        GameRegistry.registerTileEntity(TileEntityBookReceptacle.class, (ResourceLocation)new ResourceLocation("mystcraft", "crystal_receptacle"));
        GameRegistry.registerTileEntity(TileEntityLinkModifier.class, (ResourceLocation)new ResourceLocation("mystcraft", "linkmodifier"));
        GameRegistry.registerTileEntity(TileEntityBookBinder.class, (ResourceLocation)new ResourceLocation("mystcraft", "bookbinder"));
        GameRegistry.registerTileEntity(TileEntityInkMixer.class, (ResourceLocation)new ResourceLocation("mystcraft", "inkmixer"));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mystcraft", "myst.book"), EntityLinkbook.class, (String)"myst.book", (int)0, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mystcraft", "myst.block"), EntityFallingBlock.class, (String)"myst.block", (int)1, (Object)instance, (int)16, (int)10, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mystcraft", "myst.meteor"), EntityMeteor.class, (String)"myst.meteor", (int)2, (Object)instance, (int)192, (int)2, (boolean)false);
        LootTableHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)LootTableHandler.EVENT_INSTANCE);
        if (Mystcraft.archivistEnabled()) {
            this.archivist = new VillagerArchivist();
            ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)this.archivist);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandlerArchivistHouse());
        sidedProxy.init();
    }

    public static boolean archivistEnabled() {
        return archivistEnabled;
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        IMCHandler.process((ImmutableList<FMLInterModComms.IMCMessage>)messages);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        sidedProxy.postInit();
        SymbolManager.buildCardRanks();
        SymbolManager.registerRules();
        GrammarGenerator.buildGrammar();
        InstabilityDataCalculator.loadBalanceData();
        if (this.archivist != null) {
            this.archivist.registerRecipe(new MerchantRecipeProviderItem(new ItemStack(Items.field_151166_bC, 25), ItemStack.field_190927_a, new ItemStack(ModItems.booster)));
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer mcserver = event.getServer();
        event.registerServerCommand((ICommand)new CommandTPX());
        event.registerServerCommand((ICommand)new CommandCreateDim());
        event.registerServerCommand((ICommand)new CommandCreateAgebook());
        event.registerServerCommand((ICommand)new CommandToggleWorldInstability());
        if (spawnmeteorEnabled) {
            event.registerServerCommand((ICommand)new CommandSpawnMeteor());
        }
        event.registerServerCommand((ICommand)new CommandToggleDownfall());
        event.registerServerCommand((ICommand)new CommandTime());
        event.registerServerCommand((ICommand)new CommandMystPermissions());
        event.registerServerCommand((ICommand)new CommandRegenerateChunk());
        event.registerServerCommand((ICommand)new CommandReprofile());
        event.registerServerCommand((ICommand)new CommandDebug());
        this.profilingThread = new ChunkProfilerManager();
        this.profilingThread.start();
        sidedProxy.startBaselineProfiling(mcserver);
        Mystcraft.registerDimensions(mcserver.func_71218_a(0).func_72860_G());
        LinkListenerPermissions.loadState();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        TaskQueueManager.onServerStop();
        sidedProxy.stopBaselineProfiling();
        if (this.profilingThread != null) {
            this.profilingThread.halt();
            this.profilingThread = null;
        }
        Mystcraft.unregisterDimensions();
        clientStorage = null;
    }

    public static MapStorage getStorage(boolean isServer) {
        WorldServer overworld = null;
        if (isServer) {
            overworld = DimensionManager.getWorld((int)0);
        }
        if (overworld == null) {
            if (clientStorage == null) {
                throw new RuntimeException("Client-Side Storage Missing (Attempted as " + (isServer ? "server" : "remote") + ")");
            }
            return clientStorage;
        }
        return overworld.func_175693_T();
    }

    public static long getLevelSeed(MapStorage storage) {
        if (clientStorage == storage) {
            return 0L;
        }
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcServer == null) {
            return 0L;
        }
        if (DimensionManager.getWorld((int)0) == null) {
            return 0L;
        }
        return DimensionManager.getWorld((int)0).func_72905_C();
    }

    public static void unregisterDimensions() {
        deadDims = null;
        if (registeredDims == null) {
            return;
        }
        for (Integer dimId : registeredDims) {
            DimensionManager.unregisterDimension((int)dimId);
        }
        registeredDims = null;
    }

    public static void registerDimensions(ISaveHandler savehandler) {
        registeredDims = FileUtils.getExistingAgeList(savehandler.func_75758_b("dummy").getParentFile());
        deadDims = new LinkedList();
        MapStorage tempstorage = new MapStorage(savehandler);
        for (Integer dimId : registeredDims) {
            DimensionManager.registerDimension((int)dimId, (DimensionType)dimensionType);
            AgeData data = AgeData.getAge((int)dimId, tempstorage);
            if (!data.isDead()) continue;
            deadDims.add(dimId);
        }
    }

    static {
        difficulty = 2;
        instabilityEnabled = true;
        renderlabels = false;
        fastRainbows = true;
        spawnmeteorEnabled = false;
        respawnInAges = true;
        villageDeskGen = true;
        inkcost = 50;
        clientStorage = null;
        requireUUID = false;
        homeDimension = 0;
    }
}

