/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import vswe.stevescarts.api.farms.ICropModule;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotSeed;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.workers.tools.ModuleTool;
import vswe.stevescarts.plugins.APIHelper;

public abstract class ModuleFarmer
extends ModuleTool
implements ISuppliesModule {
    private ArrayList<ICropModule> plantModules;
    private int farming;
    private float farmAngle;
    private float rigAngle = -3.926991f;
    private DataParameter<Boolean> IS_FARMING;

    public ModuleFarmer(EntityMinecartModular cart) {
        super(cart);
    }

    protected abstract int getRange();

    public int getExternalRange() {
        return this.getRange();
    }

    @Override
    public void init() {
        super.init();
        this.plantModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ICropModule)) continue;
            this.plantModules.add((ICropModule)((Object)module));
        }
        for (ICropModule cropModule : APIHelper.cropModules) {
            this.plantModules.add(cropModule);
        }
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.FARMER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSeed(this.getCart(), this, slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        for (int i = -this.getRange(); i <= this.getRange(); ++i) {
            for (int j = -this.getRange(); j <= this.getRange(); ++j) {
                BlockPos coord = next.func_177982_a(i, -1, j);
                if (this.farm(world, coord)) {
                    return true;
                }
                if (this.till(world, coord)) {
                    return true;
                }
                if (!this.plant(world, coord)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean till(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            if (this.doPreWork()) {
                this.startWorking(10);
                return true;
            }
            this.stopWorking();
            world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
        }
        return false;
    }

    protected boolean plant(World world, BlockPos pos) {
        int hasSeeds = -1;
        IBlockState soilState = world.func_180495_p(pos);
        Block soilblock = soilState.func_177230_c();
        if (soilblock != null) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                IBlockState cropblock;
                if (this.getStack(i).func_190926_b() || !this.isSeedValidHandler(this.getStack(i)) || (cropblock = this.getCropFromSeedHandler(this.getStack(i), world, pos)) == null || !(cropblock.func_177230_c() instanceof IPlantable) || !world.func_175623_d(pos.func_177984_a()) || !soilblock.canSustainPlant(soilState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)cropblock.func_177230_c())) continue;
                hasSeeds = i;
                break;
            }
            if (hasSeeds != -1) {
                if (this.doPreWork()) {
                    this.startWorking(25);
                    return true;
                }
                this.stopWorking();
                IBlockState cropblock2 = this.getCropFromSeedHandler(this.getStack(hasSeeds), world, pos);
                world.func_175656_a(pos.func_177984_a(), cropblock2);
                ItemStack stack = this.getStack(hasSeeds);
                stack.func_190918_g(1);
                if (this.getStack(hasSeeds).func_190916_E() <= 0) {
                    this.setStack(hasSeeds, ItemStack.field_190927_a);
                }
            }
        }
        return false;
    }

    protected boolean farm(World world, BlockPos pos) {
        EntityMinecartModular cart = this.getCart();
        if (!this.isBroken()) {
            pos = pos.func_177984_a();
            IBlockState blockState = world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (this.isReadyToHarvestHandler(world, pos)) {
                List stuff;
                if (this.doPreWork()) {
                    int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
                    int workingtime = (int)((double)this.getBaseFarmingTime() / Math.pow(1.3f, efficiency));
                    this.setFarming(workingtime * 4);
                    this.startWorking(workingtime);
                    return true;
                }
                this.stopWorking();
                if (this.shouldSilkTouch(blockState, pos)) {
                    stuff = new ArrayList<ItemStack>();
                    ItemStack stack = this.getSilkTouchedItem(blockState);
                    if (!stack.func_190926_b()) {
                        stuff.add(stack);
                    }
                } else {
                    int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
                    stuff = block.getDrops((IBlockAccess)world, pos, blockState, fortune);
                }
                for (ItemStack iStack : stuff) {
                    cart.addItemToChest(iStack);
                    if (iStack.func_190916_E() == 0) continue;
                    EntityItem entityitem = new EntityItem(world, cart.field_70165_t, cart.field_70163_u, cart.field_70161_v, iStack);
                    entityitem.field_70159_w = (float)(pos.func_177958_n() - cart.x()) / 10.0f;
                    entityitem.field_70181_x = 0.15f;
                    entityitem.field_70179_y = (float)(pos.func_177952_p() - cart.z()) / 10.0f;
                    world.func_72838_d((Entity)entityitem);
                }
                world.func_175698_g(pos);
                this.damageTool(3);
            }
        }
        return false;
    }

    protected int getBaseFarmingTime() {
        return 25;
    }

    public boolean isSeedValidHandler(@Nonnull ItemStack seed) {
        for (ICropModule module : this.plantModules) {
            if (!module.isSeedValid(seed)) continue;
            return true;
        }
        return false;
    }

    protected IBlockState getCropFromSeedHandler(@Nonnull ItemStack seed, World world, BlockPos pos) {
        for (ICropModule module : this.plantModules) {
            if (!module.isSeedValid(seed)) continue;
            return module.getCropFromSeed(seed, world, pos);
        }
        return null;
    }

    protected boolean isReadyToHarvestHandler(World world, BlockPos pos) {
        for (ICropModule module : this.plantModules) {
            if (!module.isReadyToHarvest(world, pos)) continue;
            return true;
        }
        return false;
    }

    public float getFarmAngle() {
        return this.farmAngle;
    }

    public float getRigAngle() {
        return this.rigAngle;
    }

    @Override
    public void initDw() {
        this.IS_FARMING = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.IS_FARMING, false);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setFarming(int val) {
        this.farming = val;
        this.updateDw(this.IS_FARMING, val > 0);
    }

    protected boolean isFarming() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsFarming();
        }
        return this.getCart().isEngineBurning() && this.getDw(this.IS_FARMING) != false;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            this.setFarming(this.farming - 1);
        } else {
            float up = -3.926991f;
            float down = (float)(-Math.PI);
            boolean flag = this.isFarming();
            if (flag) {
                if (this.rigAngle < (float)(-Math.PI)) {
                    this.rigAngle += 0.1f;
                    if (this.rigAngle > (float)(-Math.PI)) {
                        this.rigAngle = (float)(-Math.PI);
                    }
                } else {
                    this.farmAngle = (float)((double)(this.farmAngle + 0.15f) % (Math.PI * 2));
                }
            } else if (this.rigAngle > -3.926991f) {
                this.rigAngle -= 0.075f;
                if (this.rigAngle < -3.926991f) {
                    this.rigAngle = -3.926991f;
                }
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.func_190926_b() || !this.isSeedValidHandler(item)) continue;
            return true;
        }
        return false;
    }
}

