/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import net.minecraft.util.text.TextFormatting;
import vswe.stevescarts.helpers.EnchantmentInfo;

public class EnchantmentData {
    private EnchantmentInfo type;
    private int value;

    public EnchantmentData(EnchantmentInfo type) {
        this.type = type;
        this.value = 0;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int val) {
        this.value = val;
    }

    public EnchantmentInfo getEnchantment() {
        return this.type;
    }

    public void setEnchantment(EnchantmentInfo info) {
        this.type = info;
    }

    public void damageEnchant(int dmg) {
        this.damageEnchantLevel(dmg, this.getValue(), 1);
    }

    private boolean damageEnchantLevel(int dmg, int value, int level) {
        if (level > this.type.getEnchantment().func_77325_b() || value <= 0) {
            return false;
        }
        int levelvalue = this.getEnchantment().getValue(level);
        if (!this.damageEnchantLevel(dmg, value - levelvalue, level + 1)) {
            int dmgdealt = dmg * (int)Math.pow(2.0, level - 1);
            if (dmgdealt > value) {
                dmgdealt = value;
            }
            this.setValue(this.getValue() - dmgdealt);
        }
        return true;
    }

    public int getLevel() {
        int value = this.getValue();
        for (int i = 0; i < this.type.getEnchantment().func_77325_b(); ++i) {
            if (value <= 0) {
                return i;
            }
            value -= this.getEnchantment().getValue(i + 1);
        }
        return this.type.getEnchantment().func_77325_b();
    }

    public String getInfoText() {
        int value = this.getValue();
        int level = 0;
        int percentage = 0;
        for (level = 1; level <= this.type.getEnchantment().func_77325_b(); ++level) {
            if (value <= 0) continue;
            int levelvalue = this.getEnchantment().getValue(level);
            percentage = 100 * value / levelvalue;
            if ((value -= levelvalue) < 0) break;
        }
        return TextFormatting.YELLOW + this.getEnchantment().getEnchantment().func_77316_c(this.getLevel()) + "\n" + percentage + "% left of this tier";
    }
}

