/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.containers.ContainerLiquid;
import vswe.stevescarts.guis.GuiManager;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

@SideOnly(value=Side.CLIENT)
public class GuiLiquid
extends GuiManager {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/liquidmanager.png");
    private static ResourceLocation textureExtra = ResourceHelper.getResource("/gui/liquidmanagerExtra.png");

    public GuiLiquid(InventoryPlayer invPlayer, TileEntityLiquid liquid) {
        super(liquid, new ContainerLiquid((IInventory)invPlayer, liquid));
        this.setXSize(230);
        this.setYSize(222);
    }

    @Override
    protected String getMaxSizeOverlay(int id) {
        int amount = this.getLiquid().getMaxAmount(id);
        if (!this.getLiquid().hasMaxAmount(id)) {
            return Localization.GUI.LIQUID.TRANSFER_ALL.translate(new String[0]);
        }
        return Localization.GUI.LIQUID.TRANSFER_BUCKETS.translate(this.getMaxSizeText(id));
    }

    @Override
    protected String getMaxSizeText(int id) {
        if (!this.getLiquid().hasMaxAmount(id)) {
            return Localization.GUI.LIQUID.TRANSFER_ALL_SHORT.translate(new String[0]);
        }
        String B = String.valueOf((float)this.getLiquid().getMaxAmount(id) / 1000.0f);
        if (B.charAt(B.length() - 1) == '0') {
            B = B.substring(0, B.length() - 2);
        } else if (B.charAt(0) == '0') {
            B = B.substring(1);
        }
        return B + Localization.GUI.LIQUID.TRANSFER_BUCKET_SHORT.translate(new String[0]);
    }

    @Override
    protected void drawBackground(int left, int top) {
        int j;
        ResourceHelper.bindResource(texture);
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.getLiquid().getTanks() != null) {
            for (int i = 0; i < 4; ++i) {
                int[] coords = this.getTankCoords(i);
                this.getLiquid().getTanks()[i].drawFluid(this, coords[0], coords[1]);
            }
        }
        ResourceHelper.bindResource(textureExtra);
        int version = this.getManager().layoutType == 0 ? 0 : 1;
        for (j = 0; j < 2; ++j) {
            this.func_73729_b(left + (j == 0 ? 27 : 171), top + 63, 0, 102 + version * 12, 32, 12);
        }
        for (j = 0; j < 4; ++j) {
            int[] coords2 = this.getTankCoords(j);
            int type = j % 2;
            this.func_73729_b(left + coords2[0], top + coords2[1], 0, 51 * type, 36, 51);
        }
    }

    @Override
    protected int getArrowSourceX() {
        return 72;
    }

    @Override
    protected int getColorSourceX() {
        return 128;
    }

    @Override
    protected int getCenterTargetX() {
        return 62;
    }

    @Override
    protected void drawColors(int id, int color, int left, int top) {
        super.drawColors(id, color, left, top);
        if (this.getManager().layoutType == 2) {
            int[] coords = this.getTankCoords(id);
            this.func_73729_b(left + coords[0], top + coords[1], 36, 51 * color, 36, 51);
        }
    }

    @Override
    protected int offsetObjectY(int layout, int x, int y) {
        return -5 + y * 10;
    }

    @Override
    protected void drawExtraOverlay(int id, int x, int y) {
        this.drawMouseOver(this.getLiquid().getTanks()[id].getMouseOver(), x, y, this.getTankCoords(id));
    }

    @Override
    protected Block getBlock() {
        return ModBlocks.LIQUID_MANAGER.getBlock();
    }

    @Override
    protected String getManagerName() {
        return Localization.GUI.LIQUID.TITLE.translate(new String[0]);
    }

    private int[] getTankCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = 25 + x * 144;
        int yCoord = 12 + y * 63;
        return new int[]{xCoord, yCoord, 36, 51};
    }

    private TileEntityLiquid getLiquid() {
        return (TileEntityLiquid)this.getManager();
    }

    @Override
    protected String getLayoutString() {
        return Localization.GUI.LIQUID.CHANGE_LAYOUT.translate(new String[0]);
    }

    @Override
    protected String getLayoutOption(int id) {
        switch (id) {
            default: {
                return Localization.GUI.LIQUID.LAYOUT_ALL.translate(new String[0]);
            }
            case 1: {
                return Localization.GUI.LIQUID.LAYOUT_SIDE.translate(new String[0]);
            }
            case 2: 
        }
        return Localization.GUI.LIQUID.LAYOUT_COLOR.translate(new String[0]);
    }
}

