/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.helpers.DetectorType;
import vswe.stevescarts.items.ItemBlockDetector;

public class BlockDetector
extends BlockContainerBase
implements ModBlocks.ICustomItemBlock,
ModBlocks.ISubtypeItemBlockModelDefinition,
ModBlocks.IStateMappedBlock {
    public static PropertyEnum<DetectorType> SATE = PropertyEnum.func_177709_a((String)"detectortype", DetectorType.class);
    public static PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockDetector() {
        super(Material.field_151594_q);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
        this.func_180632_j(this.func_176203_a(0));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (DetectorType type : DetectorType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)StevesCarts.instance, (int)6, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false && DetectorType.getTypeFromSate(blockState).shouldEmitRedstone() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        DetectorType type = DetectorType.getTypeFromSate(state);
        return type.shouldEmitRedstone() || type == DetectorType.REDSTONE;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityDetector();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = false;
        if (meta > DetectorType.values().length) {
            powered = true;
        }
        return this.func_176223_P().func_177226_a(SATE, (Comparable)((Object)DetectorType.getTypeFromint(meta - (powered ? DetectorType.values().length + 1 : 0)))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        return ((DetectorType)((Object)state.func_177229_b(SATE))).getMeta() + (powered ? DetectorType.values().length + 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SATE, POWERED});
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockDetector((Block)this);
    }

    @Override
    public int getSubtypeNumber() {
        return DetectorType.values().length;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "block_detector_" + DetectorType.values()[meta].func_176610_l();
    }

    @Override
    public void setStateMapper(StateMap.Builder builder) {
        builder.func_178442_a(new IProperty[]{POWERED});
    }
}

