/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.mushroomtower;

import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.lichtower.ComponentTFTowerRoof;
import twilightforest.structures.lichtower.ComponentTFTowerWing;

public class ComponentTFTowerRoofMushroom
extends ComponentTFTowerRoof {
    public ComponentTFTowerRoofMushroom(TFFeature feature, int i, ComponentTFTowerWing wing, float pHang) {
        super(feature, i, wing);
        this.height = wing.size;
        int overhang = (int)((float)wing.size * pHang);
        this.size = wing.size + overhang * 2;
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(wing.func_74874_b().field_78897_a - overhang, wing.func_74874_b().field_78894_e + 2, wing.func_74874_b().field_78896_c - overhang, wing.func_74874_b().field_78893_d + overhang, wing.func_74874_b().field_78894_e + this.height + 1, wing.func_74874_b().field_78892_f + overhang);
    }

    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponentOld) {
            this.deco = ((StructureTFComponentOld)parent).deco;
        }
    }

    public ComponentTFTowerRoofMushroom() {
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        for (int y = 0; y <= this.height; ++y) {
            int radius = (int)(MathHelper.func_76126_a((float)(((float)y + (float)this.height / 1.2f) / ((float)this.height * 2.05f) * 3.14f)) * (float)this.size / 2.0f);
            int hollow = MathHelper.func_76141_d((float)((float)radius * 0.9f));
            if (this.height - y < 3) {
                hollow = -1;
            }
            this.makeCircle(world, y, radius, hollow, sbb);
        }
        return true;
    }

    private void makeCircle(World world, int y, int radius, int hollow, StructureBoundingBox sbb) {
        int cx = this.size / 2;
        int cz = this.size / 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                float dist = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                if (!(dist <= (float)radius + 0.5f)) continue;
                if (dist > (float)hollow) {
                    this.func_175811_a(world, this.deco.accentState, dx + cx, y, dz + cz, sbb);
                    continue;
                }
                this.func_175811_a(world, this.deco.accentState.func_177230_c().func_176223_P(), dx + cx, y, dz + cz, sbb);
            }
        }
    }
}

