/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;

public class TFMagicMapData
extends MapData {
    public final Set<TFMapDecoration> tfDecorations = new HashSet<TFMapDecoration>();

    public TFMagicMapData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound cmp) {
        super.func_76184_a(cmp);
        byte[] featureStorage = cmp.func_74770_j("features");
        if (featureStorage.length > 0) {
            this.deserializeFeatures(featureStorage);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound cmp) {
        cmp = super.func_189551_b(cmp);
        if (this.tfDecorations.size() > 0) {
            cmp.func_74773_a("features", this.serializeFeatures());
        }
        return cmp;
    }

    public void checkExistingFeatures(World world) {
        ArrayList<TFMapDecoration> toRemove = new ArrayList<TFMapDecoration>();
        ArrayList<TFMapDecoration> toAdd = new ArrayList<TFMapDecoration>();
        for (TFMapDecoration coord : this.tfDecorations) {
            int worldZ;
            int worldX = (coord.func_176112_b() << this.field_76197_d - 1) + this.field_76201_a;
            int trueId = TFFeature.getFeatureID(worldX, worldZ = (coord.func_176113_c() << this.field_76197_d - 1) + this.field_76199_b, world);
            if (coord.featureId == trueId) continue;
            toRemove.add(coord);
            toAdd.add(new TFMapDecoration(trueId, coord.func_176112_b(), coord.func_176113_c(), coord.func_176111_d()));
        }
        this.tfDecorations.removeAll(toRemove);
        this.tfDecorations.addAll(toAdd);
    }

    public void deserializeFeatures(byte[] arr) {
        this.tfDecorations.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte featureId = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.tfDecorations.add(new TFMapDecoration(featureId, mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeFeatures() {
        byte[] storage = new byte[this.tfDecorations.size() * 3];
        int i = 0;
        for (TFMapDecoration featureCoord : this.tfDecorations) {
            storage[i * 3] = (byte)featureCoord.featureId;
            storage[i * 3 + 1] = featureCoord.func_176112_b();
            storage[i * 3 + 2] = featureCoord.func_176113_c();
            ++i;
        }
        return storage;
    }

    public void func_176054_a(double x, double z, int mapScale) {
        int mapSize = 128 * (1 << mapScale);
        int roundX = (int)Math.round(x / (double)mapSize);
        int roundZ = (int)Math.round(z / (double)mapSize);
        this.field_76201_a = roundX * mapSize;
        this.field_76199_b = roundZ * mapSize;
    }

    public static class TFMapDecoration
    extends MapDecoration {
        private static final ResourceLocation MAP_ICONS = TwilightForestMod.prefix("textures/gui/mapicons.png");
        final int featureId;

        public TFMapDecoration(int featureId, byte xIn, byte yIn, byte rotationIn) {
            super(MapDecoration.Type.TARGET_X, xIn, yIn, rotationIn);
            this.featureId = featureId;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean render(int idx) {
            if (TFFeature.getFeatureByID((int)this.featureId).isStructureEnabled) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(MAP_ICONS);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(0.0f + (float)this.func_176112_b() / 2.0f + 64.0f), (float)(0.0f + (float)this.func_176113_c() / 2.0f + 64.0f), (float)-0.02f);
                GlStateManager.func_179114_b((float)((float)(this.func_176111_d() * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)3.0f);
                GlStateManager.func_179109_b((float)-0.125f, (float)0.125f, (float)0.0f);
                float f1 = (float)(this.featureId % 8) / 8.0f;
                float f2 = (float)(this.featureId / 8) / 8.0f;
                float f3 = (float)(this.featureId % 8 + 1) / 8.0f;
                float f4 = (float)(this.featureId / 8 + 1) / 8.0f;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b(-1.0, 1.0, (double)((float)idx * -0.001f)).func_187315_a((double)f1, (double)f2).func_181675_d();
                bufferbuilder.func_181662_b(1.0, 1.0, (double)((float)idx * -0.001f)).func_187315_a((double)f3, (double)f2).func_181675_d();
                bufferbuilder.func_181662_b(1.0, -1.0, (double)((float)idx * -0.001f)).func_187315_a((double)f3, (double)f4).func_181675_d();
                bufferbuilder.func_181662_b(-1.0, -1.0, (double)((float)idx * -0.001f)).func_187315_a((double)f1, (double)f4).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof TFMapDecoration) {
                TFMapDecoration other = (TFMapDecoration)((Object)o);
                return this.featureId == other.featureId;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.featureId;
        }
    }
}

