/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnerEditor {
    public static final int SPAWN_DELAY = 20;
    public static final int MIN_SPAWN_DELAY = 200;
    public static final int MAX_SPAWN_DELAY = 800;
    public static final int SPAWN_COUNT = 4;
    public static final int MAX_NEARBY_ENTITIES = 6;
    public static final int PLAYER_RANGE = 16;
    public static final int SPAWN_RANGE = 4;
    protected TileEntityMobSpawner spawner;

    public SpawnerEditor(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMobSpawner) {
            this.spawner = (TileEntityMobSpawner)te;
        } else {
            world.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
            te = world.func_175625_s(pos);
            this.spawner = (TileEntityMobSpawner)te;
        }
    }

    public SpawnerEditor setType(Class<? extends Entity> entity) {
        this.spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(entity));
        return this;
    }

    public SpawnerEditor setDelay(int delay) {
        this.spawner.func_145881_a().field_98286_b = delay;
        return this;
    }

    public SpawnerEditor setMinDelay(int min) {
        this.spawner.func_145881_a().field_98283_g = min;
        return this;
    }

    public SpawnerEditor setMaxDelay(int max) {
        this.spawner.func_145881_a().field_98293_h = max;
        return this;
    }

    public SpawnerEditor setMinAndMaxDelay(int min, int max) {
        this.setMinDelay(min);
        this.setMaxDelay(max);
        return this;
    }

    public SpawnerEditor setSpawnCount(int count) {
        this.spawner.func_145881_a().field_98294_i = count;
        return this;
    }

    public SpawnerEditor setMaxNearbyEntities(int max) {
        this.spawner.func_145881_a().field_98292_k = max;
        return this;
    }

    public SpawnerEditor setPlayerRange(int range) {
        this.spawner.func_145881_a().field_98289_l = range;
        return this;
    }

    public SpawnerEditor setSpawnRange(int range) {
        this.spawner.func_145881_a().field_98290_m = range;
        return this;
    }

    public SpawnerEditor setSpawnData(int weight, @Nullable NBTTagCompound data) {
        this.spawner.func_145881_a().field_98282_f = data == null ? new WeightedSpawnerEntity() : new WeightedSpawnerEntity(weight, data);
        return this;
    }

    public SpawnerEditor setPotentials(WeightedSpawnerEntity ... entries) {
        this.spawner.func_145881_a().field_98285_e.clear();
        for (WeightedSpawnerEntity e : entries) {
            this.spawner.func_145881_a().field_98285_e.add(e);
        }
        return this;
    }
}

