/*
 * Decompiled with CFR 0.152.
 */
package net.modcrafters.mclib.ingredients.implementations;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.modcrafters.mclib.ingredients.IFluidIngredient;
import net.modcrafters.mclib.ingredients.IItemIngredient;
import net.modcrafters.mclib.ingredients.IMachineIngredient;
import net.modcrafters.mclib.ingredients.IngredientAmountMatch;
import net.modcrafters.mclib.ingredients.implementations.BaseItemIngredient$WhenMappings;
import net.modcrafters.mclib.inventory.IMachineInventory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lnet/modcrafters/mclib/ingredients/implementations/BaseItemIngredient;", "Lnet/modcrafters/mclib/ingredients/IItemIngredient;", "()V", "isMatch", "", "ingredient", "Lnet/modcrafters/mclib/ingredients/IMachineIngredient;", "amountMatch", "Lnet/modcrafters/mclib/ingredients/IngredientAmountMatch;", "isMatchFluid", "Lnet/modcrafters/mclib/ingredients/IFluidIngredient;", "isMatchItem", "tesla-core-lib"})
public abstract class BaseItemIngredient
implements IItemIngredient {
    @Override
    public boolean isMatch(@NotNull IMachineIngredient ingredient, @NotNull IngredientAmountMatch amountMatch) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
        IMachineIngredient iMachineIngredient = ingredient;
        return iMachineIngredient instanceof IItemIngredient ? this.isMatchItem((IItemIngredient)ingredient, amountMatch) : (iMachineIngredient instanceof IFluidIngredient ? this.isMatchFluid((IFluidIngredient)ingredient, amountMatch) : false);
    }

    protected boolean isMatchItem(@NotNull IItemIngredient ingredient, @NotNull IngredientAmountMatch amountMatch) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
            Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
            Iterable $receiver$iv = this.getItemStacks();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block6: {
                        ItemStack mine = (ItemStack)element$iv;
                        Iterable $receiver$iv2 = ingredient.getItemStacks();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                ItemStack other = (ItemStack)element$iv2;
                                if (!(mine.func_77969_a(other) && amountMatch.compare(mine.func_190916_E(), other.func_190916_E()))) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isMatchFluid(@NotNull IFluidIngredient ingredient, @NotNull IngredientAmountMatch amountMatch) {
        boolean bl;
        block7: {
            block5: {
                block6: {
                    List<ItemStack> list;
                    Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
                    List<ItemStack> it = list = this.getItemStacks();
                    if (it.size() != 1 || !it.get(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) break block5;
                    IFluidHandlerItem cap = (IFluidHandlerItem)it.get(0).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (cap == null) break block6;
                    FluidStack fluid = cap.drain(ingredient.getFluidStack(), false);
                    switch (BaseItemIngredient$WhenMappings.$EnumSwitchMapping$0[amountMatch.ordinal()]) {
                        case 1: {
                            FluidStack fluidStack = fluid;
                            bl = fluidStack != null && fluidStack.amount == ingredient.getFluidStack().amount;
                            break block7;
                        }
                        case 2: {
                            FluidStack fluidStack = fluid;
                            bl = fluidStack != null && fluidStack.amount == ingredient.getFluidStack().amount;
                            break block7;
                        }
                        case 3: {
                            FluidStack fluidStack = fluid;
                            bl = (fluidStack != null ? fluidStack.amount : 0) > 0;
                            break block7;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                bl = false;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isMatch(@NotNull IMachineInventory inventory, int slot, @NotNull IngredientAmountMatch amountMatch) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)amountMatch), (String)"amountMatch");
        return IItemIngredient.DefaultImpls.isMatch(this, inventory, slot, amountMatch);
    }

    @Override
    public boolean isSame(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IItemIngredient.DefaultImpls.isSame(this, ingredient);
    }

    @Override
    public boolean isEnough(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IItemIngredient.DefaultImpls.isEnough(this, ingredient);
    }

    @Override
    public boolean isSameIngredient(@NotNull IMachineIngredient ingredient) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IItemIngredient.DefaultImpls.isSameIngredient(this, ingredient);
    }
}

