/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import javax.annotation.Nonnull;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemStackSlot
implements IItemInInventory {
    private final IInventory inv;
    private final int slot;
    @Nonnull
    private ItemStack stack;
    @Nonnull
    private final ItemStack originalStack;
    private final boolean isCreative;
    private final boolean isEditable;
    private final int toolSlot;

    ItemStackSlot(IInventory i, int s, @Nonnull ItemStack st, ActingPlayer player, boolean canEdit) {
        this.inv = i;
        this.slot = s;
        this.stack = st;
        this.originalStack = ModUtil.copy(st);
        this.toolSlot = player.getCurrentItem();
        this.isCreative = player.isCreative();
        this.isEditable = canEdit;
    }

    @Override
    public boolean isValid() {
        return this.isEditable && (this.isCreative || !ModUtil.isEmpty(this.stack) && ModUtil.getStackSize(this.stack) > 0);
    }

    @Override
    public void damage(ActingPlayer who) {
        if (this.isCreative) {
            return;
        }
        who.damageItem(this.stack, 1);
        if (ModUtil.getStackSize(this.stack) <= 0) {
            who.playerDestroyItem(this.stack, who.getHand());
            this.inv.func_70299_a(this.slot, ModUtil.getEmptyStack());
        }
    }

    @Override
    public boolean consume() {
        if (this.isCreative) {
            return true;
        }
        if (ModUtil.getStackSize(this.stack) > 0) {
            ModUtil.adjustStackSize(this.stack, -1);
            if (ModUtil.getStackSize(this.stack) <= 0) {
                this.inv.func_70299_a(this.slot, ModUtil.getEmptyStack());
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void swapWithWeapon() {
        ItemStack it = this.inv.func_70301_a(this.toolSlot);
        this.inv.func_70299_a(this.toolSlot, this.inv.func_70301_a(this.slot));
        this.inv.func_70299_a(this.slot, it);
    }

    @Override
    public ItemStack getStackType() {
        return this.originalStack;
    }

    public void replaceStack(@Nonnull ItemStack restockItem) {
        this.stack = restockItem;
        this.inv.func_70299_a(this.slot, restockItem);
    }
}

