/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import magicbees.MagicBees;
import magicbees.api.module.IConfigRegistry;
import magicbees.api.module.IConfiguration;
import magicbees.api.module.IMagicBeesInitialisationEvent;
import magicbees.api.module.IMagicBeesModule;
import magicbees.api.module.MagicBeesModule;
import magicbees.elec332.corerepack.util.FMLUtil;
import magicbees.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.lang3.tuple.Triple;

public enum ModuleHandler {
    INSTANCE;

    private final Multimap<ModContainer, Triple<IMagicBeesModule, String, List<String>>> modules = HashMultimap.create();

    public void preInit(FMLPreInitializationEvent event) {
        block2: for (ASMDataTable.ASMData disc : event.getAsmData().getAll(MagicBeesModule.class.getName())) {
            Map data2 = disc.getAnnotationInfo();
            String mod = (String)data2.get("owner");
            ModContainer owner = FMLUtil.findMod(mod);
            if (owner == null) {
                MagicBees.logger.error("Found module without owner!");
                continue;
            }
            String name = (String)data2.get("name");
            String deps_ = (String)data2.get("modDependencies");
            String[] deps = Strings.isNullOrEmpty((String)deps_) ? new String[]{} : deps_.split(";");
            ArrayList lDeps = Lists.newArrayList();
            if (deps.length != 0) {
                for (String dep : deps) {
                    if (Strings.isNullOrEmpty((String)dep)) continue;
                    if (!Loader.isModLoaded((String)dep)) {
                        MagicBees.logger.info("Mod " + dep + " not detected, not activating module " + name);
                        continue block2;
                    }
                    lDeps.add(dep);
                }
            }
            try {
                Class<?> c = FMLUtil.loadClass(disc.getClassName());
                Object obj = c.newInstance();
                if (!(obj instanceof IMagicBeesModule)) {
                    MagicBees.logger.error("Module " + name + " is not instanceof IMagicBeesModule, skipping...");
                    continue;
                }
                IMagicBeesModule module = (IMagicBeesModule)obj;
                this.modules.put((Object)owner, (Object)Triple.of((Object)module, (Object)name, (Object)lDeps));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.runEvent("Preinitializing", data -> ((IMagicBeesModule)data.getLeft()).preInit());
    }

    public void registerConfig(final IConfigRegistry configRegistry) {
        final HashSet configRegistrySet = Sets.newHashSet();
        final String start = "integration";
        IConfigRegistry registry = new IConfigRegistry(){

            @Override
            public void registerConfig(IConfiguration config) {
                if (configRegistrySet.add(config)) {
                    config.init(this);
                }
            }

            @Override
            public void registerCategoryComment(String category, String comment) {
                configRegistry.registerCategoryComment(start + "." + category, comment);
            }
        };
        this.runEvent(null, data -> ((IMagicBeesModule)data.getLeft()).registerConfig(registry));
        configRegistry.registerConfig((Configuration config) -> {
            this.fixConfigOrder(config, start);
            config.getCategory(start);
            Configuration wrapped = new Configuration(config.getConfigFile()){

                public ConfigCategory getCategory(String category) {
                    return config.getCategory(start + "." + category);
                }

                public void save() {
                }

                public void load() {
                }
            };
            configRegistrySet.forEach(config_ -> config_.reload(wrapped));
        });
        configRegistry.registerCategoryComment(start, "Mod integration settings");
    }

    public void init() {
        MBIE event = new MBIE();
        this.runEvent("Initializing", data -> {
            List deps = (List)data.getRight();
            if (deps.size() == 1) {
                event.mod = (String)deps.get(0);
            } else {
                event.mod = null;
            }
            ((IMagicBeesModule)data.getLeft()).init(event);
        });
    }

    public void postInit() {
        this.runEvent("Postinitializing", data -> ((IMagicBeesModule)data.getLeft()).postInit());
    }

    private void runEvent(String s, Consumer<Triple<IMagicBeesModule, String, List<String>>> run) {
        for (ModContainer mc : this.modules.keySet()) {
            if (s != null) {
                MagicBees.logger.info(s + " modules for mod " + mc.getModId() + "...");
            }
            int modules = 0;
            for (Triple moduleData : this.modules.get((Object)mc)) {
                if (s != null) {
                    MagicBees.logger.info("   " + s + " module " + (String)moduleData.getMiddle());
                }
                run.accept((Triple<IMagicBeesModule, String, List<String>>)moduleData);
                ++modules;
            }
            if (s == null) continue;
            MagicBees.logger.info(s.replace("ing", "ed ") + modules + " module" + (modules > 1 ? "s" : "") + " for mod " + mc.getModId());
        }
    }

    private void fixConfigOrder(Configuration config, String last) {
        try {
            Field f = Configuration.class.getDeclaredField("categories");
            f.setAccessible(true);
            TreeMap current = (TreeMap)f.get(config);
            if (current.comparator() != null) {
                return;
            }
            TreeMap tm = new TreeMap((o1, o2) -> {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o1.equals(last)) {
                    return 1;
                }
                if (o2.equals(last)) {
                    return -1;
                }
                return ((Comparable)o1).compareTo(o2);
            });
            tm.putAll(current);
            f.set(config, tm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class MBIE
    implements IMagicBeesInitialisationEvent {
        private String mod;

        private MBIE() {
        }

        @Override
        @Nonnull
        public Block getBlock(String name) {
            if (Strings.isNullOrEmpty((String)this.mod)) {
                throw new IllegalArgumentException();
            }
            return this.getBlock(this.mod, name);
        }

        @Override
        @Nonnull
        public Item getItem(String name) {
            if (Strings.isNullOrEmpty((String)this.mod)) {
                throw new IllegalArgumentException();
            }
            return this.getItem(this.mod, name);
        }

        @Override
        @Nonnull
        public Block getBlock(String mod, String name) {
            return Utils.getBlock(mod, name);
        }

        @Override
        @Nonnull
        public Item getItem(String mod, String name) {
            return Utils.getItem(mod, name);
        }
    }
}

