/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.thaumcraft.effects;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import java.util.Random;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import magicbees.integration.thaumcraft.util.AuraHelper;
import magicbees.integration.thaumcraft.util.TaintHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.lib.SoundsTC;

public class AlleleEffectDarkHunger
extends AlleleEffectThrottled {
    private static final float VIS_REQUIRED = 16383.5f;

    public AlleleEffectDarkHunger(ResourceLocation rl) {
        super(rl);
        this.setRequiresWorkingQueen();
        this.setThrottle(1000);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AuraHelper.handleRandomChunk(genome, housing, auraChunk -> {
            List<EntityLiving> l;
            EffectData data = (EffectData)storedData;
            World world = housing.getWorldObj();
            Random random = world.field_73012_v;
            float nom = random.nextFloat() * 100.0f;
            if (auraChunk.getVis() > nom + 1.0f) {
                auraChunk.setVis(auraChunk.getVis() - nom);
                data.setFloat(0, data.getFloat(0) + nom);
            } else {
                TaintHelper.explodeTaint(housing.getCoordinates(), world, auraChunk, random, data.getFloat(0), auraChunk.getVis(), nom, 16383.5f);
            }
            if (data.getFloat(0) >= 16383.5f && (l = AlleleEffectDarkHunger.getEntitiesInRange(genome, housing, EntityLiving.class, e -> !(e instanceof IEldritchMob) && !(e instanceof ITaintedMob) && !(e instanceof IMob))).size() > 0) {
                EntityLiving el = l.get(random.nextInt(l.size()));
                el.func_70097_a(DamageSource.field_76376_m, 1000000.0f);
                Vec3d pos = el.func_174791_d();
                Object e2 = (double)random.nextFloat() > 0.3 ? new EntityCultistKnight(world) : new EntityCultistCleric(world);
                e2.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                e2.func_180482_a(world.func_175649_E(new BlockPos((Vec3i)e2.func_180425_c())), null);
                data.setFloat(0, 0.0f);
                world.func_72838_d((Entity)e2);
                e2.func_70656_aK();
                e2.func_184185_a(SoundsTC.wandfail, 1.0f, 1.0f);
            }
        });
        storedData.setInteger(0, 0);
        return storedData;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 1);
        }
        return storedData;
    }
}

