/*
 * Decompiled with CFR 0.152.
 */
package magicbees;

import forestry.api.apiculture.BeeManager;
import magicbees.api.ICrumblingHandler;
import magicbees.api.ITransmutationController;
import magicbees.api.ITransmutationHandler;
import magicbees.bees.EnumBeeBranches;
import magicbees.bees.EnumBeeHives;
import magicbees.bees.EnumBeeSpecies;
import magicbees.client.ModelHandler;
import magicbees.elec332.corerepack.compat.forestry.ForestryCompatHandler;
import magicbees.elec332.corerepack.compat.forestry.IndividualDefinitionRegistry;
import magicbees.elec332.corerepack.util.LoadTimer;
import magicbees.init.AlleleRegister;
import magicbees.init.BlockRegister;
import magicbees.init.ItemRegister;
import magicbees.init.RecipeRegister;
import magicbees.inventory.GuiHandler;
import magicbees.item.types.EnumResourceType;
import magicbees.util.Config;
import magicbees.util.ConfigHandler;
import magicbees.util.DefaultCrumblingHandler;
import magicbees.util.DefaultTransmutationController;
import magicbees.util.MagicBeesCreativeTab;
import magicbees.util.ModuleHandler;
import magicbees.util.WorldGenBeeSpeciesCache;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="magicbees", name="MagicBees", dependencies="required-after:forestry@[5.6.0,)", acceptedMinecraftVersions="[1.12,)", useMetadata=true)
public class MagicBees {
    public static final String modid = "magicbees";
    public static final String modName = "MagicBees";
    @Mod.Instance(value="magicbees")
    public static MagicBees instance;
    public static Logger logger;
    private static LoadTimer loadTimer;
    public static CreativeTabs creativeTab;
    private static ConfigHandler config;
    public static boolean debug;
    private ForestryCompatHandler forestryCompatHandler;
    public static ICrumblingHandler crumblingHandler;
    public static ITransmutationController transmutationController;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)modName);
        loadTimer = new LoadTimer(logger, modName);
        loadTimer.startPhase((FMLStateEvent)event);
        this.forestryCompatHandler = new ForestryCompatHandler();
        this.forestryCompatHandler.preInit(event);
        crumblingHandler = new DefaultCrumblingHandler();
        transmutationController = new DefaultTransmutationController(new ITransmutationHandler[0]);
        creativeTab = new MagicBeesCreativeTab();
        config = new ConfigHandler(new Configuration(event.getSuggestedConfigurationFile()));
        debug = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        MinecraftForge.EVENT_BUS.register((Object)new ItemRegister());
        MinecraftForge.EVENT_BUS.register((Object)new BlockRegister());
        MinecraftForge.EVENT_BUS.register((Object)new RecipeRegister());
        BlockRegister.preInit();
        ItemRegister.preInit();
        ModuleHandler.INSTANCE.preInit(event);
        ModuleHandler.INSTANCE.registerConfig(config);
        config.registerConfig(new Config());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new ModelHandler());
        }
        loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        loadTimer.startPhase((FMLStateEvent)event);
        this.forestryCompatHandler.init(event);
        EnumBeeBranches.registerClassifications();
        AlleleRegister.init();
        ItemRegister.registerOreDictionary();
        RecipeRegister.init();
        config.reload();
        ModuleHandler.INSTANCE.init();
        logger.info("Registering " + EnumBeeSpecies.values().length + " new bee species!");
        IndividualDefinitionRegistry.registerBees(EnumBeeSpecies.class);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        loadTimer.startPhase((FMLStateEvent)event);
        this.forestryCompatHandler.postInit(event);
        for (EnumBeeHives h : EnumBeeHives.values()) {
            h.registerDrops();
        }
        WorldGenBeeSpeciesCache.populateSpeciesListRarity();
        BeeManager.inducers.put(ItemRegister.resourceItem.getStackFromType(EnumResourceType.AROMATIC_LUMP).func_77946_l(), 95);
        ModuleHandler.INSTANCE.postInit();
        loadTimer.endPhase((FMLStateEvent)event);
    }
}

