/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.patcher;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.repackage.com.nothome.delta.Delta;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenDiffSet {
    private static final List<String> RESERVED_NAMES = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");

    public static void main(String[] args) throws IOException {
        String sourceJar = args[0];
        String targetDir = args[1];
        String deobfData = args[2];
        String outputDir = args[3];
        String killTarget = args[4];
        Logger logger = LogManager.getLogger((String)"FML.GENDIFF");
        logger.info("Creating patches at {} for {} from {}", (Object)outputDir, (Object)sourceJar, (Object)targetDir);
        Delta delta = new Delta();
        FMLDeobfuscatingRemapper remapper = FMLDeobfuscatingRemapper.INSTANCE;
        remapper.setupLoadOnly(deobfData, false);
        JarFile sourceZip = new JarFile(sourceJar);
        boolean kill = killTarget.equalsIgnoreCase("true");
        File f = new File(outputDir);
        f.mkdirs();
        Iterator<String> iterator = remapper.getObfedClasses().iterator();
        while (iterator.hasNext()) {
            String name;
            String fileName = name = iterator.next();
            String jarName = name;
            if (RESERVED_NAMES.contains(name.toUpperCase(Locale.ENGLISH))) {
                fileName = "_" + name;
            }
            File targetFile = new File(targetDir, fileName.replace('/', File.separatorChar) + ".class");
            jarName = jarName + ".class";
            if (!targetFile.exists()) continue;
            String sourceClassName = name.replace('/', '.');
            String targetClassName = remapper.map(name).replace('/', '.');
            JarEntry entry = sourceZip.getJarEntry(jarName);
            byte[] vanillaBytes = GenDiffSet.toByteArray(sourceZip, entry);
            byte[] patchedBytes = Files.toByteArray((File)targetFile);
            byte[] diff = delta.compute(vanillaBytes, patchedBytes);
            ByteArrayDataOutput diffOut = ByteStreams.newDataOutput((int)(diff.length + 50));
            diffOut.writeUTF(name);
            diffOut.writeUTF(sourceClassName);
            diffOut.writeUTF(targetClassName);
            diffOut.writeBoolean(entry != null);
            if (entry != null) {
                diffOut.writeInt(Hashing.adler32().hashBytes(vanillaBytes).asInt());
            }
            diffOut.writeInt(diff.length);
            diffOut.write(diff);
            File target = new File(outputDir, targetClassName + ".binpatch");
            target.getParentFile().mkdirs();
            Files.write((byte[])diffOut.toByteArray(), (File)target);
            logger.info("Wrote patch for {} ({}) at {}", (Object)name, (Object)targetClassName, (Object)target.getAbsolutePath());
            if (!kill) continue;
            targetFile.delete();
            logger.info("  Deleted target: {}", (Object)targetFile);
        }
        sourceZip.close();
    }

    private static byte[] toByteArray(JarFile sourceZip, @Nullable JarEntry entry) throws IOException {
        if (entry == null) {
            return new byte[0];
        }
        try (InputStream sourceZipInputStream = sourceZip.getInputStream(entry);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)sourceZipInputStream);
            return byArray;
        }
    }
}

