/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import org.jurassicraft.server.world.structure.StructureGenerator;

public class RaptorPaddockGenerator
extends StructureGenerator {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("jurassicraft", "raptor_paddock");

    public RaptorPaddockGenerator(Random rand) {
        super(rand, 32, 16, 23);
    }

    @Override
    protected void generateStructure(World world, Random random, BlockPos position) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        Map dataBlocks = template.func_186258_a(position, settings);
        template.func_186260_a(world, position, settings);
        dataBlocks.forEach((pos, type) -> {
            if (type.equals("Chest")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tile = world.func_175625_s(pos.func_177977_b());
                if (tile instanceof TileEntityChest) {
                    ((TileEntityChest)tile).func_189404_a(LootTableList.field_186423_e, random.nextLong());
                }
            }
        });
    }

    @Override
    public int getOffsetY() {
        return -1;
    }
}

