/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.structure;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.OrientedBlock;
import org.jurassicraft.server.world.loot.Loot;

public class GeneticistVillagerHouse
extends StructureVillagePieces.Village {
    public static final int WIDTH = 8;
    public static final int HEIGHT = 6;
    public static final int DEPTH = 14;
    public static final IBlockState[] MACHINES = new IBlockState[]{BlockHandler.DNA_EXTRACTOR.func_176223_P(), BlockHandler.DNA_SEQUENCER.func_176223_P(), BlockHandler.DNA_COMBINATOR_HYBRIDIZER.func_176223_P(), BlockHandler.DNA_SYNTHESIZER.func_176223_P(), BlockHandler.EMBRYONIC_MACHINE.func_176223_P()};
    private static final ResourceLocation STRUCTURE = new ResourceLocation("jurassicraft", "geneticist_house");
    private int count;
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;

    public GeneticistVillagerHouse() {
    }

    public GeneticistVillagerHouse(StructureVillagePieces.Start start, int type, StructureBoundingBox bounds, EnumFacing facing) {
        super(start, type);
        this.func_186164_a(facing);
        this.field_74887_e = bounds;
    }

    public void func_186164_a(EnumFacing facing) {
        super.func_186164_a(facing);
        this.coordBaseMode = facing;
        if (facing == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
        MinecraftServer server = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_186222_a(true);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        if (this.field_143015_k < 0) {
            this.field_143015_k = this.func_74889_b(world, bounds);
            if (this.field_143015_k < 0) {
                return false;
            }
            settings.func_186222_a(false);
            this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
        }
        int ox = this.rotation == Rotation.CLOCKWISE_90 && this.mirror == Mirror.NONE ? 14 : -1;
        int oz = this.rotation == Rotation.NONE && this.mirror == Mirror.LEFT_RIGHT ? 14 : -1;
        BlockPos lowerCorner = new BlockPos(this.field_74887_e.field_78897_a + ox, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + oz);
        settings.func_186223_a(new StructureBoundingBox(this.field_74887_e.field_78897_a + ox, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + oz, this.field_74887_e.field_78893_d + ox, this.field_74887_e.field_78892_f, this.field_74887_e.field_78892_f + oz));
        template.func_186260_a(world, lowerCorner, settings);
        ++this.count;
        Map dataBlocks = template.func_186258_a(lowerCorner, settings);
        Map<BlockPos, String> dataBlocksClone = dataBlocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        dataBlocks.forEach((pos, type) -> {
            IBlockState base = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            switch (type) {
                case "GeneticistChest": {
                    world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.rotate(this.coordBaseMode, this.mirror == Mirror.LEFT_RIGHT)));
                    ((TileEntityChest)world.func_175625_s(pos)).func_189404_a(Loot.GENETICIST_HOUSE_CHEST, random.nextLong());
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "GeneticistMachine": {
                    if (random.nextInt(4) == 0) {
                        IBlockState machine = MACHINES[random.nextInt(MACHINES.length)];
                        if (machine.func_177230_c() instanceof OrientedBlock) {
                            OrientedBlock cfr_ignored_0 = (OrientedBlock)machine.func_177230_c();
                            world.func_175656_a(pos, machine.func_177226_a((IProperty)OrientedBlock.FACING, (Comparable)this.rotate(this.coordBaseMode, this.mirror == Mirror.LEFT_RIGHT)));
                        } else {
                            world.func_175656_a(pos, machine);
                        }
                    }
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Log": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150364_r.func_176223_P()));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Base": {
                    world.func_175656_a(pos, base);
                    this.clearCurrentPositionBlocksUpwards(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 7, pos.func_177952_p()), bounds);
                    this.replaceAirAndLiquidDownwards(world, base, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), bounds);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "BaseStairs": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.coordBaseMode)));
                    this.clearCurrentPositionBlocksUpwards(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 7, pos.func_177952_p()), bounds);
                    this.replaceAirAndLiquidDownwards(world, base, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), bounds);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Wall": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150344_f.func_176223_P()));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "BaseWood": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150344_f.func_176223_P()));
                    this.clearCurrentPositionBlocksUpwards(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 7, pos.func_177952_p()), bounds);
                    this.replaceAirAndLiquidDownwards(world, base, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), bounds);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Hay": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_150407_cf.func_176223_P()));
                    this.clearCurrentPositionBlocksUpwards(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 7, pos.func_177952_p()), bounds);
                    this.replaceAirAndLiquidDownwards(world, base, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), bounds);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Fence": {
                    world.func_175656_a(pos, this.func_175847_a(Blocks.field_180407_aO.func_176223_P()));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "FenceGate": {
                    IBlockState gate;
                    switch (this.field_189928_h) {
                        case 2: {
                            gate = Blocks.field_180387_bt.func_176223_P();
                            break;
                        }
                        case 3: {
                            gate = Blocks.field_180391_bp.func_176223_P();
                            break;
                        }
                        default: {
                            gate = Blocks.field_180390_bo.func_176223_P();
                        }
                    }
                    world.func_175656_a(pos, gate.func_185907_a(this.rotation).func_185902_a(this.mirror));
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "StainedClay": {
                    IBlockState state = this.func_175847_a(Blocks.field_150364_r.func_176223_P());
                    if (state.func_177227_a().contains(BlockLog.field_176299_a)) {
                        state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                    }
                    world.func_175656_a(pos, state);
                    dataBlocksClone.remove(pos);
                    break;
                }
                case "Bricks": {
                    IBlockState brick = Blocks.field_150417_aV.func_176223_P();
                    if (this.field_189928_h == 1) {
                        brick = Blocks.field_150322_A.func_176223_P();
                    }
                    world.func_175656_a(pos, brick);
                    dataBlocksClone.remove(pos);
                }
            }
        });
        dataBlocksClone.forEach((pos, type) -> {
            switch (type) {
                case "Door": {
                    world.func_175656_a(pos, this.func_189925_i().func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)this.coordBaseMode));
                    break;
                }
                case "DoorTop": {
                    world.func_175656_a(pos, this.func_189925_i().func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)this.coordBaseMode).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_185907_a(this.rotation).func_185902_a(this.mirror));
                    break;
                }
                case "Torch": {
                    if (this.field_189929_i) break;
                    world.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P());
                    break;
                }
                case "TorchDoor": {
                    if (this.field_189929_i) break;
                    world.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)this.coordBaseMode));
                }
            }
        });
        dataBlocksClone.clear();
        return true;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("count", this.count);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        this.count = tagCompound.func_74762_e("count");
    }

    public void clearCurrentPositionBlocksUpwards(World world, BlockPos pos, StructureBoundingBox boundingBox) {
        if (boundingBox.func_175898_b((Vec3i)pos)) {
            while (!world.func_175623_d(pos) && pos.func_177956_o() < 255) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                pos = pos.func_177984_a();
            }
        }
    }

    public void replaceAirAndLiquidDownwards(World world, IBlockState blockstate, BlockPos pos, StructureBoundingBox boundingBox) {
        if (boundingBox.func_175898_b((Vec3i)pos)) {
            while ((world.func_175623_d(pos) || world.func_180495_p(pos).func_185904_a().func_76224_d()) && pos.func_177956_o() > 1) {
                world.func_180501_a(pos, blockstate, 2);
                pos = pos.func_177977_b();
            }
        }
    }

    public EnumFacing rotate(EnumFacing facing, boolean clockwise) {
        if (!clockwise) {
            switch (facing) {
                case NORTH: {
                    return EnumFacing.EAST;
                }
                case EAST: {
                    return EnumFacing.SOUTH;
                }
                case SOUTH: {
                    return EnumFacing.WEST;
                }
                case WEST: {
                    return EnumFacing.NORTH;
                }
            }
            throw new IllegalStateException("Rotation failed while generation for: " + facing);
        }
        switch (facing) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
        }
        throw new IllegalStateException("Rotation failed while generation for: " + facing + " which is clockwise");
    }

    public static class CreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int size) {
            return new StructureVillagePieces.PieceWeight(GeneticistVillagerHouse.class, 1, MathHelper.func_76136_a((Random)random, (int)0, (int)1));
        }

        public Class<?> getComponentClass() {
            return GeneticistVillagerHouse.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int minX, int minY, int minZ, EnumFacing facing, int componentType) {
            StructureBoundingBox bounds = StructureBoundingBox.func_175897_a((int)minX, (int)minY, (int)minZ, (int)0, (int)0, (int)0, (int)8, (int)6, (int)14, (EnumFacing)facing);
            return StructureComponent.func_74883_a(pieces, (StructureBoundingBox)bounds) == null ? new GeneticistVillagerHouse(startPiece, componentType, bounds, facing) : null;
        }
    }
}

