/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.genetics.GeneticsHelper;
import org.jurassicraft.server.item.DisplayBlockItem;
import org.jurassicraft.server.item.FossilItem;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;

public class Loot {
    public static final ResourceLocation GENETICIST_HOUSE_CHEST = new ResourceLocation("jurassicraft", "structure/geneticist_house");
    public static final ResourceLocation VISITOR_GROUND_STORAGE = new ResourceLocation("jurassicraft", "structure/visitor_centre/ground_storage");
    public static final ResourceLocation VISITOR_CONTROL_ROOM = new ResourceLocation("jurassicraft", "structure/visitor_centre/control_room");
    public static final ResourceLocation VISITOR_LABORATORY = new ResourceLocation("jurassicraft", "structure/visitor_centre/laboratory");
    public static final ResourceLocation VISITOR_CRYONICS = new ResourceLocation("jurassicraft", "structure/visitor_centre/cryonics");
    public static final ResourceLocation VISITOR_INFIRMARY = new ResourceLocation("jurassicraft", "structure/visitor_centre/infirmary");
    public static final ResourceLocation VISITOR_GARAGE = new ResourceLocation("jurassicraft", "structure/visitor_centre/garage");
    public static final ResourceLocation VISITOR_STAFF_DORMS = new ResourceLocation("jurassicraft", "structure/visitor_centre/staff_dorms");
    public static final ResourceLocation VISITOR_KITCHEN = new ResourceLocation("jurassicraft", "structure/visitor_centre/kitchen");
    public static final ResourceLocation VISITOR_DORM_TOWER = new ResourceLocation("jurassicraft", "structure/visitor_centre/dorm_tower");
    public static final ResourceLocation VISITOR_DINING_HALL = new ResourceLocation("jurassicraft", "structure/visitor_centre/dining_hall");
    public static final ResourceLocation FOSSIL_DIGSITE_LOOT = new ResourceLocation("jurassicraft", "structure/fossil_digsite");
    public static final DinosaurData DINOSAUR_DATA = new DinosaurData();
    public static final PlantData PLANT_DATA = new PlantData();
    public static final RandomDNA RANDOM_DNA = new RandomDNA();
    public static final PotionData POTION_DATA = new PotionData();
    public static final RandomDNA FULL_DNA = new RandomDNA(true);
    private static long tableID = 0L;

    public static PoolBuilder pool(String name) {
        return new PoolBuilder(name);
    }

    public static EntryBuilder entry(Item item) {
        return new EntryBuilder(item);
    }

    public static EntryBuilder entry(Block block) {
        return new EntryBuilder(Item.func_150898_a((Block)block));
    }

    public static MultiEntryBuilder entries(Item ... items) {
        return new MultiEntryBuilder(items);
    }

    public static LootEntry[] entries(Object ... entryData) {
        LootEntry[] builders = new LootEntry[entryData.length / 3];
        for (int i = 0; i < entryData.length; i += 3) {
            Object itemData = entryData[i];
            Item item = itemData instanceof Block ? Item.func_150898_a((Block)((Block)itemData)) : (Item)itemData;
            EntryBuilder entry = Loot.entry(item).count((Integer)entryData[i + 1], (Integer)entryData[i + 2]);
            builders[i / 3] = entry.build();
        }
        return builders;
    }

    public static void handleTable(LootTable table, ResourceLocation name) {
        boolean frozen = false;
        if (table.isFrozen()) {
            frozen = true;
            ReflectionHelper.setPrivateValue(LootTable.class, (Object)table, (Object)false, (String[])new String[]{"isFrozen"});
            for (LootPool lootPool : (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String[])new String[]{"pools", "field_186466_c"})) {
                ReflectionHelper.setPrivateValue(LootPool.class, (Object)lootPool, (Object)false, (String[])new String[]{"isFrozen"});
            }
        }
        if (name == LootTableList.field_186387_al) {
            LootEntry gracilaria = Loot.entry(ItemHandler.GRACILARIA).weight(25).build();
            table.addPool(Loot.pool("gracilaria").rolls(1, 1).chance(0.1f).entry(gracilaria).build());
        } else if (name == LootTableList.field_186423_e || name == LootTableList.field_186425_g || name == LootTableList.field_186422_d || name == LootTableList.field_186428_j || name == LootTableList.field_186429_k || name == LootTableList.field_186424_f) {
            float percentage = (float)JurassiCraftConfig.ITEMS.lootSpawnrate / 100.0f;
            LootEntry plantFossil = Loot.entry(ItemHandler.PLANT_FOSSIL).weight(5).count((int)percentage, (int)(3.0f * percentage)).build();
            LootEntry twig = Loot.entry(ItemHandler.TWIG_FOSSIL).weight(5).count((int)percentage, (int)(3.0f * percentage)).build();
            LootEntry amber = Loot.entry(ItemHandler.AMBER).weight(2).count(0, (int)percentage).data(0, 1).build();
            LootEntry skull = Loot.entry(ItemHandler.FOSSILS.get("skull")).weight(2).function(DINOSAUR_DATA).count((int)percentage, (int)(2.0f * percentage)).build();
            table.addPool(Loot.pool("fossils").rolls(1, 2).entries(plantFossil, twig, amber, skull).build());
            LootEntry[] records = Loot.entries(new Item[]{ItemHandler.JURASSICRAFT_THEME_DISC, ItemHandler.DONT_MOVE_A_MUSCLE_DISC, ItemHandler.TROODONS_AND_RAPTORS_DISC}).buildEntries();
            table.addPool(Loot.pool("records").rolls(0, (int)(2.0f * percentage)).entries(records).build());
        }
        if (name.func_110624_b().equals("jurassicraft")) {
            if (name.func_110623_a().equals(VISITOR_GROUND_STORAGE.func_110623_a())) {
                LootEntry amber = Loot.entry(ItemHandler.AMBER).data(0, 1).count(0, 3).build();
                LootEntry wool = Loot.entry(Blocks.field_150325_L).data(0, 15).count(0, 64).build();
                table.addPool(Loot.pool("items").rolls(5, 6).entries(amber, wool).build());
            } else if (name.func_110623_a().equals(VISITOR_LABORATORY.func_110623_a())) {
                LootEntry softTissue = Loot.entry(ItemHandler.SOFT_TISSUE).count(0, 3).function(DINOSAUR_DATA).build();
                LootEntry plantSoftTissue = Loot.entry(ItemHandler.PLANT_SOFT_TISSUE).count(0, 3).function(PLANT_DATA).build();
                LootEntry amber = Loot.entry(ItemHandler.AMBER).data(0, 1).count(0, 5).build();
                LootEntry dna = Loot.entry(ItemHandler.DNA).function(DINOSAUR_DATA).function(RANDOM_DNA).build();
                table.addPool(Loot.pool("items").rolls(3, 4).entries(dna, softTissue, plantSoftTissue, amber).build());
            } else if (name.func_110623_a().equals(VISITOR_DINING_HALL.func_110623_a())) {
                LootEntry amber = Loot.entry(ItemHandler.AMBER).weight(2).count(0, 1).data(0, 1).build();
                LootEntry tooth = Loot.entry(ItemHandler.FOSSILS.get("tooth")).weight(2).function(DINOSAUR_DATA).count(1, 2).build();
                LootEntry actionFigure = Loot.entry(ItemHandler.DISPLAY_BLOCK_ITEM).function(DINOSAUR_DATA).weight(1).build();
                table.addPool(Loot.pool("items").rolls(8, 11).entries(amber, tooth, actionFigure).build());
            } else if (name.func_110623_a().equals(VISITOR_KITCHEN.func_110623_a())) {
                LootEntry waterBottle = Loot.entry((Item)Items.field_151068_bn).count(0, 1).function(POTION_DATA).build();
                table.addPool(Loot.pool("items").rolls(3, 4).entries(waterBottle).build());
            } else if (name.func_110623_a().equals(FOSSIL_DIGSITE_LOOT.func_110623_a())) {
                LootEntry fossilPart = Loot.entry(ItemHandler.FOSSIL_DUMMY).weight(1).function(DINOSAUR_DATA).count(1, 1).build();
                LootEntry fossilPart2 = Loot.entry(ItemHandler.FOSSIL_DUMMY).weight(2).function(DINOSAUR_DATA).count(1, 2).build();
                table.addPool(Loot.pool("items").rolls(6, 9).entries(fossilPart, fossilPart2).build());
            }
        }
        if (frozen) {
            table.freeze();
        }
    }

    public static class WrittenBook
    extends LootFunction {
        private final String title;
        private final String author;
        private final String[] pages;

        public WrittenBook(LootCondition[] conditions, String title, String author, String[] pages) {
            super(conditions);
            this.title = title;
            this.author = author;
            this.pages = pages;
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                stack.func_77982_d(compound);
            }
            compound.func_74757_a("resolved", false);
            compound.func_74768_a("generation", 0);
            compound.func_74778_a("title", this.title);
            compound.func_74778_a("author", this.author);
            NBTTagList pages = new NBTTagList();
            for (String page : this.pages) {
                pages.func_74742_a((NBTBase)new NBTTagString(page));
            }
            compound.func_74782_a("pages", (NBTBase)pages);
            return stack;
        }
    }

    public static class RandomDNA
    extends LootFunction {
        private boolean full;

        public RandomDNA() {
            super(new LootCondition[0]);
        }

        public RandomDNA(LootCondition[] conditions) {
            super(conditions);
        }

        public RandomDNA(boolean full) {
            this();
            this.full = full;
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            int quality = (rand.nextInt(10) + 1) * 5;
            if (this.full) {
                quality = 100;
            }
            DinoDNA dna = new DinoDNA(EntityHandler.getDinosaurById(stack.func_77952_i()), quality, GeneticsHelper.randomGenetics(rand));
            NBTTagCompound compound = new NBTTagCompound();
            dna.writeToNBT(compound);
            stack.func_77982_d(compound);
            return stack;
        }
    }

    public static class PlantData
    extends LootFunction {
        public PlantData() {
            super(new LootCondition[0]);
        }

        public PlantData(LootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            List<Plant> plants = PlantHandler.getPrehistoricPlants();
            Plant plant = plants.get(rand.nextInt(plants.size()));
            stack.func_77964_b(PlantHandler.getPlantId(plant));
            return stack;
        }
    }

    public static class PotionData
    extends LootFunction {
        public PotionData() {
            super(new LootCondition[0]);
        }

        public PotionData(LootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            stack = PotionUtils.func_185188_a((ItemStack)stack, (PotionType)PotionTypes.field_185230_b);
            stack.func_77964_b(0);
            return stack;
        }
    }

    public static class DinosaurData
    extends LootFunction {
        public DinosaurData() {
            super(new LootCondition[0]);
        }

        public DinosaurData(LootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            List<Dinosaur> dinosaurs = EntityHandler.getRegisteredDinosaurs();
            Dinosaur dinosaur = dinosaurs.get(rand.nextInt(dinosaurs.size()));
            if (stack.func_77973_b() instanceof FossilItem) {
                String boneName = dinosaur.getMetadata().getBones()[rand.nextInt(dinosaur.getMetadata().getBones().length)];
                stack = new ItemStack((Item)ItemHandler.FOSSILS.get(boneName), 1, EntityHandler.getDinosaurId(dinosaur));
                return stack;
            }
            if (stack.func_77973_b() instanceof DisplayBlockItem) {
                DisplayBlockItem s = (DisplayBlockItem)stack.func_77973_b();
                stack.func_77964_b(DisplayBlockItem.getMetadata(EntityHandler.getDinosaurId(dinosaur), false, false));
                return stack;
            }
            stack.func_77964_b(EntityHandler.getDinosaurId(dinosaur));
            return stack;
        }
    }

    public static class MultiEntryBuilder
    extends EntryBuilder {
        protected Item[] items;

        private MultiEntryBuilder(Item ... items) {
            super(null);
            this.items = items;
        }

        public LootEntry[] buildEntries() {
            LootCondition[] conditions = this.conditions.toArray(new LootCondition[0]);
            LootFunction[] functions = this.functions.toArray(new LootFunction[0]);
            LootEntry[] entries = new LootEntry[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                Item item = this.items[i];
                entries[i] = new LootEntryItem(item, this.weight, this.quality, functions, conditions, item.func_77658_a() + "_" + tableID++);
            }
            return entries;
        }
    }

    public static class EntryBuilder {
        protected Item item;
        protected int weight = 1;
        protected int quality = 0;
        protected List<LootCondition> conditions = new ArrayList<LootCondition>();
        protected List<LootFunction> functions = new ArrayList<LootFunction>();

        private EntryBuilder(Item item) {
            this.item = item;
        }

        public EntryBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public EntryBuilder quality(int quality) {
            this.quality = quality;
            return this;
        }

        public EntryBuilder condition(LootCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public EntryBuilder tag(NBTTagCompound compound) {
            return this.function((LootFunction)new SetNBT(new LootCondition[0], compound));
        }

        public EntryBuilder function(LootFunction function) {
            this.functions.add(function);
            return this;
        }

        public EntryBuilder count(int min, int max) {
            return this.function((LootFunction)new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max)));
        }

        public EntryBuilder data(int min, int max) {
            return this.function((LootFunction)new SetMetadata(new LootCondition[0], new RandomValueRange((float)min, (float)max)));
        }

        public EntryBuilder data(int data) {
            return this.data(data, data);
        }

        public LootEntry build() {
            LootCondition[] conditions = this.conditions.toArray(new LootCondition[0]);
            LootFunction[] functions = this.functions.toArray(new LootFunction[0]);
            return new LootEntryItem(this.item, this.weight, this.quality, functions, conditions, this.item.func_77658_a() + "_" + tableID++);
        }
    }

    public static class PoolBuilder {
        private String name;
        private int minRolls;
        private int maxRolls = 1;
        private int minBonusRolls;
        private int maxBonusRolls;
        private List<LootCondition> conditions = new ArrayList<LootCondition>();
        private List<LootEntry> entries = new ArrayList<LootEntry>();

        private PoolBuilder(String name) {
            this.name = name;
        }

        public PoolBuilder rolls(int min, int max) {
            this.minRolls = min;
            this.maxRolls = max;
            return this;
        }

        public PoolBuilder bonusRolls(int min, int max) {
            this.minBonusRolls = min;
            this.maxBonusRolls = max;
            return this;
        }

        public PoolBuilder condition(LootCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public PoolBuilder chance(float chance) {
            return this.condition((LootCondition)new RandomChance(chance));
        }

        public PoolBuilder entry(LootEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public PoolBuilder entries(LootEntry ... entries) {
            for (LootEntry entry : entries) {
                this.entry(entry);
            }
            return this;
        }

        public LootPool build() {
            LootEntry[] entries = this.entries.toArray(new LootEntry[0]);
            LootCondition[] conditions = this.conditions.toArray(new LootCondition[0]);
            return new LootPool(entries, conditions, new RandomValueRange((float)this.minRolls, (float)this.maxRolls), new RandomValueRange((float)this.minBonusRolls, (float)this.maxBonusRolls), this.name);
        }
    }
}

