/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.util;

import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.item.AttractionSignEntity;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;

public final class LangUtils {
    public static final TranslateKey COLORS = new TranslateKey("color.%s.name");
    public static final TranslateKey PLANTS = new TranslateKey("plants.%s.name");
    public static final TranslateKey LORE = new TranslateKey("lore.%s.name");
    public static final TranslateKey TAME = new TranslateKey("message.tame.name");
    public static final TranslateKey SET_ORDER = new TranslateKey("message.set_order.name");
    public static final TranslateKey ORDER_VALUE = new TranslateKey("order.%s.name");
    public static final TranslateKey GENDER_CHANGE = new TranslateKey("%s.genderchange.name");
    public static final TranslateKey SKELETON_CHANGE = new TranslateKey("%s.skeletonchange.name");
    public static final TranslateKey STAND_CHANGE = new TranslateKey("%s.standchange.name");
    public static final TranslateKey GUI = new TranslateKey("gui.%s.name");
    public static final TranslateKey STATUS = new TranslateKey("status.%s.name");
    public static final TranslateKey ENTITY_NAME = new TranslateKey("entity.%s.name");
    public static final TranslateKey ENTITY_DESC = new TranslateKey("entity.%s.desc");
    public static final TranslateKey CONTAINER_INV = new TranslateKey("container.inventory");

    public static String translate(String langKey, Object ... args) {
        return I18n.func_94522_b((String)langKey) ? I18n.func_74837_a((String)langKey, (Object[])args) : langKey;
    }

    public static String translate(TranslateKey langKey, Object ... args) {
        return LangUtils.translate(langKey.key, args);
    }

    public static String translateOrDefault(String langKey, String defaultVal) {
        return I18n.func_94522_b((String)langKey) ? LangUtils.translate(langKey, new Object[0]) : defaultVal;
    }

    public static String translateOrDefault(TranslateKey langKey, String defaultVal) {
        return LangUtils.translateOrDefault(langKey.key, defaultVal);
    }

    public static String translateEntityCls(Class<? extends Entity> eClass) {
        String namedEntry = EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(eClass));
        if (namedEntry != null) {
            return LangUtils.translate(ENTITY_NAME.get(namedEntry), new Object[0]);
        }
        return "[UNKNOWN] " + eClass.getName();
    }

    public static String translateEntityClsDesc(Class<? extends Entity> eClass) {
        String namedEntry = EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(eClass));
        if (namedEntry != null) {
            return LangUtils.translate(ENTITY_DESC.get(namedEntry), new Object[0]);
        }
        return "";
    }

    public static String getFormattedQuality(int quality) {
        return (quality == -1 ? TextFormatting.OBFUSCATED : "") + Integer.toString(quality);
    }

    public static String getFormattedGenetics(String genetics) {
        return genetics.isEmpty() ? TextFormatting.OBFUSCATED + "aaa" : genetics;
    }

    public static String getDinoName(Dinosaur dinosaur) {
        ResourceLocation identifier = dinosaur.getIdentifier();
        return LangUtils.translate(ENTITY_NAME.get(identifier.func_110624_b() + "." + identifier.func_110623_a()), new Object[0]);
    }

    public static String getDinoInfo(Dinosaur dinosaur) {
        ResourceLocation identifier = dinosaur.getIdentifier();
        return LangUtils.translate("info." + identifier.func_110624_b() + "." + identifier.func_110623_a() + ".name", new Object[0]);
    }

    public static String getAttractionSignName(ItemStack stack) {
        return LangUtils.translate("attraction_sign." + AttractionSignEntity.AttractionSignType.values()[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH) + ".name", new Object[0]);
    }

    public static String getGenderMode(int mode) {
        String modeString = "";
        switch (mode) {
            case 0: {
                modeString = "random";
                break;
            }
            case 1: {
                modeString = "male";
                break;
            }
            case 2: {
                modeString = "female";
            }
        }
        return LangUtils.translate("gender." + modeString + ".name", new Object[0]);
    }

    public static String getSkeletonMode(Dinosaur dinosaur, int variant) {
        return dinosaur.getMetadata().skeletonPoses()[variant];
    }

    public static String getStandType(boolean type) {
        return type ? LangUtils.translate("stand.stand.name", new Object[0]) : LangUtils.translate("stand.placed.name", new Object[0]);
    }

    public static String getPlantName(int plantId) {
        if (plantId == -1) {
            return TextFormatting.OBFUSCATED + "aaa";
        }
        return LangUtils.getPlantName(PlantHandler.getPlantById(plantId));
    }

    public static String getPlantName(Plant plant) {
        return LangUtils.translate("plants." + (plant == null ? "null" : plant.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")) + ".name", new Object[0]);
    }

    public static final class TranslateKey {
        private final String key;

        public TranslateKey(String key) {
            this.key = key;
        }

        public TranslateKey(String key, Object ... args) {
            this(String.format(key, args));
        }

        public String get() {
            return this.key;
        }

        public String get(Object ... args) {
            return String.format(this.key, args);
        }
    }
}

