/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.proxy;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.BugCrateBlockEntity;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.container.CleaningStationContainer;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.container.DNACombinatorHybridizerContainer;
import org.jurassicraft.server.container.DNAExtractorContainer;
import org.jurassicraft.server.container.DNASequencerContainer;
import org.jurassicraft.server.container.DNASynthesizerContainer;
import org.jurassicraft.server.container.EmbryoCalcificationMachineContainer;
import org.jurassicraft.server.container.EmbryonicMachineContainer;
import org.jurassicraft.server.container.FeederContainer;
import org.jurassicraft.server.container.FossilGrinderContainer;
import org.jurassicraft.server.container.IncubatorContainer;
import org.jurassicraft.server.container.SkeletonAssemblyContainer;
import org.jurassicraft.server.datafixers.JurassiCraftDataFixers;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.GoatEntity;
import org.jurassicraft.server.entity.villager.VillagerHandler;
import org.jurassicraft.server.event.ServerEventHandler;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.food.FoodNutrients;
import org.jurassicraft.server.genetics.StorageTypeRegistry;
import org.jurassicraft.server.item.FossilItem;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.item.JournalItem;
import org.jurassicraft.server.maps.VillagerTradeHandler;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.recipe.SmeltingRecipeHandler;
import org.jurassicraft.server.util.RegistryHandler;
import org.jurassicraft.server.world.WorldGenerator;
import org.jurassicraft.server.world.structure.StructureGenerationHandler;

public class ServerProxy
implements IGuiHandler {
    public static final int GUI_CLEANING_STATION_ID = 0;
    public static final int GUI_FOSSIL_GRINDER_ID = 1;
    public static final int GUI_DNA_SEQUENCER_ID = 2;
    public static final int GUI_EMBRYONIC_MACHINE_ID = 3;
    public static final int GUI_EMBRYO_CALCIFICATION_MACHINE_ID = 4;
    public static final int GUI_DNA_SYNTHESIZER_ID = 5;
    public static final int GUI_INCUBATOR_ID = 6;
    public static final int GUI_DNA_COMBINATOR_HYBRIDIZER_ID = 7;
    public static final int GUI_DNA_EXTRACTOR_ID = 8;
    public static final int GUI_CULTIVATOR_ID = 9;
    public static final int GUI_FEEDER_ID = 10;
    public static final int GUI_BUG_CRATE = 11;
    public static final int GUI_SKELETON_ASSEMBLER = 12;

    public void onPreInit(FMLPreInitializationEvent event) {
        EntityHandler.init();
        FossilItem.init();
        PlantHandler.init();
        BlockHandler.init();
        ItemHandler.init();
        StorageTypeRegistry.init();
        StructureGenerationHandler.registerInit();
        VillagerHandler.init();
        FoodNutrients.register();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGenerator.INSTANCE, (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)JurassiCraft.INSTANCE, (IGuiHandler)this);
        MinecraftForge.EVENT_BUS.register(RegistryHandler.class);
        MinecraftForge.EVENT_BUS.register(ServerEventHandler.class);
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        FoodHelper.init();
        BlockHandler.registerOres();
        ItemHandler.registerOres();
        JurassiCraftDataFixers.init();
        SmeltingRecipeHandler.init();
        VillagerTradeHandler.init();
    }

    public void onInit(FMLInitializationEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            List list = biome.func_76747_a(EnumCreatureType.CREATURE);
            ServerProxy.addSpawn(list);
        }
        Blocks.field_150480_ab.func_180686_a((Block)BlockHandler.VINES, 15, 100);
    }

    private static void addSpawn(List<Biome.SpawnListEntry> list) {
        boolean shouldAddGoat = false;
        for (Biome.SpawnListEntry entry : list) {
            if (entry.field_76300_b != EntityPig.class) continue;
            shouldAddGoat = true;
        }
        if (shouldAddGoat && JurassiCraftConfig.ENTITIES.naturalSpawning_G) {
            list.add(new Biome.SpawnListEntry(GoatEntity.class, 10, 2, 4));
        }
    }

    public static void reinitSpawns() {
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            List list = biome.func_76747_a(EnumCreatureType.CREATURE);
            list.removeIf(entry -> entry.field_76300_b == GoatEntity.class);
            ServerProxy.addSpawn(list);
        }
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            switch (id) {
                case 0: {
                    if (!(tile instanceof CleaningStationBlockEntity)) break;
                    return new CleaningStationContainer(player.field_71071_by, (TileEntity)((CleaningStationBlockEntity)tile));
                }
                case 1: {
                    if (!(tile instanceof FossilGrinderBlockEntity)) break;
                    return new FossilGrinderContainer(player.field_71071_by, tile);
                }
                case 2: {
                    if (!(tile instanceof DNASequencerBlockEntity)) break;
                    return new DNASequencerContainer(player.field_71071_by, tile);
                }
                case 3: {
                    if (!(tile instanceof EmbryonicMachineBlockEntity)) break;
                    return new EmbryonicMachineContainer(player.field_71071_by, tile);
                }
                case 4: {
                    if (!(tile instanceof EmbryoCalcificationMachineBlockEntity)) break;
                    return new EmbryoCalcificationMachineContainer(player.field_71071_by, tile);
                }
                case 5: {
                    if (!(tile instanceof DNASynthesizerBlockEntity)) break;
                    return new DNASynthesizerContainer(player.field_71071_by, tile);
                }
                case 6: {
                    if (!(tile instanceof IncubatorBlockEntity)) break;
                    return new IncubatorContainer(player.field_71071_by, tile);
                }
                case 7: {
                    if (!(tile instanceof DNACombinatorHybridizerBlockEntity)) break;
                    return new DNACombinatorHybridizerContainer(player.field_71071_by, tile);
                }
                case 8: {
                    if (!(tile instanceof DNAExtractorBlockEntity)) break;
                    return new DNAExtractorContainer(player.field_71071_by, tile);
                }
                case 9: {
                    if (!(tile instanceof CultivatorBlockEntity)) break;
                    return new CultivateContainer(player.field_71071_by, tile);
                }
                case 10: {
                    if (!(tile instanceof FeederBlockEntity)) break;
                    return new FeederContainer(player.field_71071_by, (FeederBlockEntity)tile);
                }
                case 11: {
                    if (!(tile instanceof BugCrateBlockEntity)) break;
                    return ((BugCrateBlockEntity)tile).func_174876_a(player.field_71071_by, player);
                }
                default: {
                    return null;
                }
            }
        }
        switch (id) {
            case 12: {
                return new SkeletonAssemblyContainer(player.field_71071_by, world, pos);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void openSelectDino(BlockPos pos, EnumFacing facing, EnumHand hand) {
    }

    public void openOrder(DinosaurEntity entity) {
    }

    public void openFieldGuide(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo fieldGuideInfo) {
    }

    public void openJournal(JournalItem.JournalType type) {
    }
}

