/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei.category.moss;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.plugin.jei.category.moss.PeatRecipeWrapper;
import org.jurassicraft.server.util.LangUtils;

public class PeatRecipeCategory
implements IRecipeCategory<PeatRecipeWrapper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/peat.png");
    private final IDrawable background;
    private final String title;
    private final IDrawableAnimated arrow;

    public PeatRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 132, 45);
        this.title = LangUtils.translate("info.jei.peat_block.name", new Object[0]);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(TEXTURE, 133, 0, 23, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.isSelected(mouseX, mouseY, 7.0, 7.0)) {
            tooltips.add("Water");
        } else if (this.isSelected(mouseX, mouseY, 7.0, 25.0)) {
            tooltips.add(LangUtils.translate("tile.moss_on_peat.name", new Object[0]));
        } else if (this.isSelected(mouseX, mouseY, 25.0, 25.0)) {
            tooltips.add(LangUtils.translate("tile.peat.name", new Object[0]));
        }
        if (this.isSelected(mouseX, mouseY, 89.0, 7.0)) {
            tooltips.add("Water");
        } else if (this.isSelected(mouseX, mouseY, 89.0, 25.0)) {
            tooltips.add(LangUtils.translate("tile.moss_on_peat.name", new Object[0]));
        } else if (this.isSelected(mouseX, mouseY, 107.0, 25.0)) {
            tooltips.add(LangUtils.translate("tile.moss_on_peat.name", new Object[0]));
        } else {
            super.getTooltipStrings(mouseX, mouseY);
        }
        return tooltips;
    }

    public boolean isSelected(double mouseX, double mouseY, double x, double y) {
        return mouseX >= x && mouseY >= y && mouseX < x + 16.0 && mouseY < y + 16.0;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 54, 17);
        this.drawBlock(minecraft, 25, 25, BlockHandler.PEAT);
        this.drawBlock(minecraft, 7, 25, BlockHandler.PEAT_MOSS);
        this.drawWater(minecraft, 7, 7);
        this.drawBlock(minecraft, 107, 25, BlockHandler.PEAT_MOSS);
        this.drawBlock(minecraft, 89, 25, BlockHandler.PEAT_MOSS);
        this.drawWater(minecraft, 89, 7);
        String text = LangUtils.translate("info.jei.peat.name", new Object[0]);
        int y = 52;
        for (String s : text.split("<nl>")) {
            minecraft.field_71466_p.func_78276_b(s, 7, y, 0);
            y += 10;
        }
    }

    public void drawBlock(Minecraft minecraft, int x, int y, Block block) {
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IBlockState state = block.func_176223_P();
        BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        List upQuads = null;
        IBakedModel model = bms.func_178125_b(state);
        upQuads = model.func_188616_a(state, EnumFacing.UP, 0L);
        TextureAtlasSprite sprite = upQuads == null || upQuads.isEmpty() ? bms.func_178122_a(state) : ((BakedQuad)upQuads.get(0)).func_187508_a();
        this.drawSprite(minecraft, x, y, sprite);
    }

    public void drawWater(Minecraft minecraft, int x, int y) {
        FluidStack stack = new FluidStack(FluidRegistry.WATER, 1);
        Fluid fluid = stack.getFluid();
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureMap blockTextures = minecraft.func_147117_R();
        TextureAtlasSprite sprite = blockTextures.getTextureExtry(fluid.getStill().toString());
        int color = fluid.getColor(stack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        this.drawSprite(minecraft, x, y, sprite);
    }

    public void drawSprite(Minecraft minecraft, int x, int y, TextureAtlasSprite sprite) {
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + 16), 300.0).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + 16), (double)(y + 16), 300.0).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + 16), (double)y, 300.0).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)y, 300.0).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public String getUid() {
        return "jurassicraft.peat";
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getModName() {
        return "JurassiCraft";
    }

    public void setRecipe(IRecipeLayout recipeLayout, PeatRecipeWrapper recipeWrapper, IIngredients ingredients) {
    }
}

