/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei.category.dnasynthesizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.container.DNASequencerContainer;
import org.jurassicraft.server.message.DNASequenceTransferClicked;

public class DNASequencerTransferHandler
implements IRecipeTransferHandler<DNASequencerContainer> {
    private final IRecipeTransferHandlerHelper helper;

    public DNASequencerTransferHandler(IRecipeTransferHandlerHelper helper) {
        this.helper = helper;
    }

    public Class<DNASequencerContainer> getContainerClass() {
        return DNASequencerContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(DNASequencerContainer container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        DNASequencerBlockEntity blockEntity = (DNASequencerBlockEntity)container.getInventoryTile();
        int nextProcessID = 0;
        boolean canBeProcessed = false;
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.isProcessing(nextProcessID)) {
                ++nextProcessID;
                continue;
            }
            canBeProcessed = true;
            break;
        }
        if (!canBeProcessed) {
            return this.helper.createUserErrorWithTooltip("Machine is full");
        }
        int slotOffset = nextProcessID * 2;
        HashMap requiredInputs = Maps.newHashMap();
        ArrayList linkedInputMap = Lists.newArrayList();
        ArrayList leftInputs = Lists.newArrayList();
        recipeLayout.getItemStacks().getGuiIngredients().forEach((id, ingredient) -> {
            if (ingredient.isInput()) {
                requiredInputs.put(id + slotOffset, ingredient.getAllIngredients());
                leftInputs.add(id);
            }
        });
        ArrayList foundStacks = Lists.newArrayList();
        for (int i = 9; i < 45; ++i) {
            Slot slot = container.func_75139_a(i);
            ItemStack stack = slot.func_75211_c();
            for (Map.Entry entry : requiredInputs.entrySet()) {
                block3: for (ItemStack requiredStack : (List)entry.getValue()) {
                    if (!requiredStack.func_77969_a(stack) || !container.func_75139_a((Integer)entry.getKey()).func_75214_a(stack)) continue;
                    for (ItemStack foundStack : foundStacks) {
                        if (!foundStack.func_77969_a(stack)) continue;
                        continue block3;
                    }
                    foundStacks.add(stack);
                    linkedInputMap.add(Pair.of((Object)i, entry.getKey()));
                    leftInputs.remove((Object)((Integer)entry.getKey() - slotOffset));
                }
            }
        }
        if (!leftInputs.isEmpty()) {
            return this.helper.createUserErrorForSlots(I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]), (Collection)leftInputs);
        }
        if (doTransfer) {
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new DNASequenceTransferClicked(linkedInputMap));
        }
        return null;
    }

    public static void setItemServer(EntityPlayer player, List<Pair<Integer, Integer>> list) {
        Container container = player.field_71070_bA;
        list.forEach(pair -> {
            Slot fromSlot = container.func_75139_a(((Integer)pair.getLeft()).intValue());
            Slot toSlot = container.func_75139_a(((Integer)pair.getRight()).intValue());
            ItemStack prevStack = toSlot.func_75211_c();
            toSlot.func_75215_d(fromSlot.func_75211_c().func_77979_a(1));
            if (!prevStack.func_190926_b()) {
                for (int i = 9; i < 45; ++i) {
                    Slot slot = container.func_75139_a(i);
                    if (slot.func_75216_d()) continue;
                    slot.func_75215_d(prevStack);
                }
            }
        });
    }
}

