/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.plugin.jei.category.cultivate;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.IntSupplier;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.plugin.jei.category.cultivate.CultivatorRecipeWrapper;

public class CultivatorRecipeCategory
implements IRecipeCategory<CultivatorRecipeWrapper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/gui/cultivator_jei.png");
    private final IDrawable background;
    private final String title;
    private List<NutrientBar> nutrientBarList;

    public CultivatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 169, 90);
        this.title = I18n.func_74838_a((String)"tile.cultivator.name");
    }

    public void drawExtras(Minecraft minecraft) {
        this.nutrientBarList.forEach(rec$ -> ((NutrientBar)rec$).render());
    }

    public String getUid() {
        return "jurassicraft.cultivator";
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CultivatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        stackGroup.init(0, true, 40, 6);
        stackGroup.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        stackGroup.init(1, false, 105, 6);
        stackGroup.set(1, (List)ingredients.getOutputs(ItemStack.class).get(0));
        DinosaurMetadata metadata = recipeWrapper.getDinosaur().getMetadata();
        Object[] objectArray = new NutrientBar[4];
        objectArray[0] = new NutrientBar(metadata::getProximates, 0);
        objectArray[1] = new NutrientBar(metadata::getMinerals, 1);
        objectArray[2] = new NutrientBar(metadata::getVitamins, 2);
        objectArray[3] = new NutrientBar(metadata::getLipids, 3);
        this.nutrientBarList = Lists.newArrayList((Object[])objectArray);
    }

    public String getModName() {
        return "JurassiCraft";
    }

    private class NutrientBar {
        private final int id;
        private final int value;

        private NutrientBar(IntSupplier supplier, int id) {
            this.id = id;
            this.value = supplier.getAsInt();
        }

        private void render() {
            this.drawTexturedModalRect(9, 30 + this.id * 16, 0, 91 + this.id * 9, this.value * 150 / 3000, 9);
        }

        public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
            bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

