/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.server.entity.DinosaurEntity;

public class SetOrderMessage
extends AbstractMessage<SetOrderMessage> {
    private int entityId;
    private DinosaurEntity.Order order;

    public SetOrderMessage() {
    }

    public SetOrderMessage(DinosaurEntity entity) {
        this.entityId = entity.func_145782_y();
        this.order = entity.getOrder();
    }

    public void onClientReceived(Minecraft minecraft, SetOrderMessage message, EntityPlayer player, MessageContext messageContext) {
    }

    public void onServerReceived(MinecraftServer server, SetOrderMessage message, EntityPlayer player, MessageContext messageContext) {
        DinosaurEntity dinosaur;
        Entity entity = player.func_130014_f_().func_73045_a(message.entityId);
        if (entity instanceof DinosaurEntity && (dinosaur = (DinosaurEntity)entity).getOwner() != null && dinosaur.getOwner().equals(player.func_110124_au())) {
            dinosaur.setFieldOrder(message.order);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.order = DinosaurEntity.Order.values()[Math.max(0, buf.readByte() % DinosaurEntity.Order.values().length)];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.order.ordinal());
    }
}

