/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.entity.item.PaddockSignEntity;
import org.jurassicraft.server.item.ItemHandler;

public class PlacePaddockSignMessage
extends AbstractMessage<PlacePaddockSignMessage> {
    private int dino;
    private BlockPos pos;
    private int x;
    private int y;
    private int z;
    private EnumFacing facing;
    private EnumHand hand;

    public PlacePaddockSignMessage() {
    }

    public PlacePaddockSignMessage(EnumHand hand, EnumFacing facing, BlockPos pos, Dinosaur dino) {
        this.dino = EntityHandler.getDinosaurId(dino);
        this.pos = new BlockPos(this.x, this.y, this.z);
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.facing = facing;
        this.hand = hand;
    }

    public void onClientReceived(Minecraft minecraft, PlacePaddockSignMessage message, EntityPlayer player, MessageContext messageContext) {
    }

    public void onServerReceived(MinecraftServer server, PlacePaddockSignMessage message, EntityPlayer player, MessageContext messageContext) {
        World world = player.field_70170_p;
        EnumFacing side = message.facing;
        BlockPos pos = message.pos;
        PaddockSignEntity paddockSign = new PaddockSignEntity(world, pos, side, message.dino);
        ItemStack heldItem = player.func_184586_b(message.hand);
        if (heldItem != null && heldItem.func_77973_b() == ItemHandler.PADDOCK_SIGN && player.func_175151_a(pos, side, heldItem) && paddockSign.func_70518_d()) {
            world.func_72838_d((Entity)paddockSign);
            if (!player.field_71075_bZ.field_75098_d) {
                InventoryPlayer inventory = player.field_71071_by;
                inventory.func_70298_a(inventory.field_70461_c, 1);
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.dino);
        buffer.writeByte((int)((byte)this.facing.func_176745_a()));
        buffer.writeByte((int)((byte)this.hand.ordinal()));
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.dino = buffer.readInt();
        this.facing = EnumFacing.func_82600_a((int)buffer.readByte());
        this.hand = EnumHand.values()[buffer.readByte()];
        this.pos = new BlockPos(this.x, this.y, this.z);
    }
}

