/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.maps;

import com.google.common.collect.Lists;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jurassicraft.server.world.structure.StructureUtils;

public class MapUtils {
    private static final int MIN_DISTANCE = 5000;
    private static final int MAX_DISTANCE = 10000;

    public static BlockPos getVisitorCenterPosition() {
        StructureUtils.StructureData data = StructureUtils.getStructureData();
        BlockPos pos = data.getVisitorCenterPosition();
        if (pos == null) {
            pos = MapUtils.generatePosition();
            data.setVisitorCenterPosition(pos);
        }
        return pos;
    }

    private static BlockPos generatePosition() {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        Random worldRandom = new Random(world.func_72905_C());
        int range = 5000;
        BlockPos pos = null;
        for (int i = 0; i < 10000; ++i) {
            pos = new BlockPos(worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1), 0, worldRandom.nextInt(range) + 5000 * (worldRandom.nextBoolean() ? 1 : -1));
            if (!Lists.newArrayList((Object[])new Biome[]{Biomes.field_76782_w, Biomes.field_185446_X, Biomes.field_150574_L, Biomes.field_185447_Y, Biomes.field_150588_X, Biomes.field_185435_ag}).contains(world.func_180494_b(pos))) continue;
            return pos;
        }
        return pos;
    }
}

