/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;

public class TwigFossilItem
extends Item
implements GrindableItem {
    public TwigFossilItem() {
        this.func_77637_a(TabHandler.PLANTS);
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(4);
        if (outputType == 3) {
            ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(TreeType.values()[random.nextInt(TreeType.values().length)].getPlant()));
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 2) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        NBTTagCompound tag = inputItem.func_77978_p();
        float single = 25.0f;
        float treeSingle = single / (float)TreeType.values().length;
        for (TreeType treeType : TreeType.values()) {
            ItemStack output = new ItemStack((Item)ItemHandler.PLANT_SOFT_TISSUE, 1, PlantHandler.getPlantId(treeType.getPlant()));
            output.func_77982_d(tag);
            list.add(Pair.of((Object)Float.valueOf(treeSingle), (Object)output));
        }
        list.add(Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 15)));
        list.add(Pair.of((Object)Float.valueOf(single), (Object)new ItemStack(Items.field_151145_ak)));
        return list;
    }
}

