/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.server.api.SynthesizableItem;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.genetics.PlantDNA;
import org.jurassicraft.server.genetics.StorageType;
import org.jurassicraft.server.genetics.StorageTypeRegistry;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;

public class StorageDiscItem
extends Item
implements SynthesizableItem {
    public StorageDiscItem() {
        this.func_77637_a(TabHandler.ITEMS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> toolTip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            String storageId = tag.func_74779_i("StorageId");
            StorageType type = StorageTypeRegistry.getStorageType(storageId);
            if (type != null) {
                type.readFromNBT(tag);
                type.addInformation(stack, toolTip);
            }
        } else {
            toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)"cage.empty.name", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean isSynthesizable(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound != null && tagCompound.func_74764_b("DNAQuality") && tagCompound.func_74762_e("DNAQuality") == 100;
    }

    @Override
    public ItemStack getSynthesizedItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        StorageType type = StorageTypeRegistry.getStorageType(tag.func_74779_i("StorageId"));
        type.readFromNBT(tag);
        return type.createItem();
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        NBTTagCompound tag = inputItem.func_77978_p();
        StorageType type = StorageTypeRegistry.getStorageType(tag.func_74779_i("StorageId"));
        type.readFromNBT(tag);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(100.0f), (Object)type.createItem())});
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        ArrayList list = Lists.newArrayList();
        EntityHandler.getRegisteredDinosaurs().forEach(dino -> {
            DinoDNA dna = new DinoDNA((Dinosaur)dino, -1, "");
            ItemStack stack = new ItemStack((Item)this);
            NBTTagCompound nbt = new NBTTagCompound();
            dna.writeToNBT(nbt);
            stack.func_77982_d(nbt);
            list.add(stack);
        });
        PlantHandler.getPlants().stream().filter(plant -> plant.isPrehistoric()).forEach(plant -> {
            PlantDNA dna = new PlantDNA(PlantHandler.getPlantId(plant), -1);
            ItemStack stack = new ItemStack((Item)this);
            NBTTagCompound nbt = new NBTTagCompound();
            dna.writeToNBT(nbt);
            stack.func_77982_d(nbt);
            list.add(stack);
        });
        return list;
    }
}

