/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.DinosaurMetadata;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.DNAContainerItem;
import org.jurassicraft.server.util.LangUtils;

public class HatchedEggItem
extends DNAContainerItem {
    public HatchedEggItem() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        DinosaurMetadata metadata = HatchedEggItem.getDinosaur(stack).getMetadata();
        return LangUtils.translate(metadata.givesDirectBirth() ? "item.gestated.name" : "item.hatched_egg.name", new Object[0]).replace("{dino}", LangUtils.getDinoName(HatchedEggItem.getDinosaur(stack)));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + LangUtils.translate("gender.name", new Object[0]) + ": " + HatchedEggItem.getItemGender(stack));
    }

    public static Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77960_j());
    }

    public static String getItemGender(ItemStack stack) {
        Boolean gender = null;
        NBTTagCompound nbt = stack.func_77978_p();
        if (stack.func_77942_o() && nbt.func_74764_b("Gender")) {
            gender = nbt.func_74767_n("Gender");
        }
        return LangUtils.getGenderMode(gender != null ? (gender.booleanValue() ? 1 : 2) : 0);
    }

    public static boolean getGender(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        boolean gender = player.field_70170_p.field_73012_v.nextBoolean();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("Gender")) {
            gender = nbt.func_74767_n("Gender");
        } else {
            nbt.func_74757_a("Gender", gender);
        }
        stack.func_77982_d(nbt);
        return gender;
    }

    @Override
    public int getContainerId(ItemStack stack) {
        return EntityHandler.getDinosaurId(HatchedEggItem.getDinosaur(stack));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(side);
        ItemStack stack = player.func_184586_b(hand);
        if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
            hitX = 1.0f - hitX;
        } else if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            hitZ = 1.0f - hitZ;
        }
        if (player.func_175151_a(pos, side, stack)) {
            if (!world.field_72995_K) {
                Dinosaur dinosaur = HatchedEggItem.getDinosaur(stack);
                DinosaurEntity entity = dinosaur.construct(world);
                entity.func_70107_b((float)pos.func_177958_n() + hitX, pos.func_177956_o(), (float)pos.func_177952_p() + hitZ);
                entity.setAge(0);
                entity.setGenetics(HatchedEggItem.getGeneticCode(player, stack));
                entity.setDNAQuality(HatchedEggItem.getDNAQuality(player, stack));
                entity.setMale(HatchedEggItem.getGender(player, stack));
                if (!player.func_70093_af()) {
                    entity.setOwner(player);
                }
                world.func_72838_d((Entity)entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

