/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2d;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.SkullDisplay;
import org.jurassicraft.server.block.entity.SkullDisplayEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.TyrannosaurusDinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangUtils;

public class FossilItem
extends Item
implements GrindableItem {
    public static Map<String, List<Dinosaur>> fossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    private String type;
    private boolean fresh;

    public FossilItem(String type, boolean fresh) {
        this.type = type.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        this.fresh = fresh;
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.FOSSILS);
    }

    public static void init() {
        for (Dinosaur dinosaur : EntityHandler.getDinosaurs().values()) {
            String[] boneTypes;
            for (String boneType : boneTypes = dinosaur.getMetadata().getBones()) {
                List<Dinosaur> dinosaursWithType = fossilDinosaurs.get(boneType);
                if (dinosaursWithType == null) {
                    dinosaursWithType = new ArrayList<Dinosaur>();
                }
                dinosaursWithType.add(dinosaur);
                fossilDinosaurs.put(boneType, dinosaursWithType);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = FossilItem.getDinosaur(stack);
        if (dinosaur != null) {
            return LangUtils.translate(this.func_77658_a() + ".name", new Object[0]).replace("{dino}", LangUtils.getDinoName(dinosaur));
        }
        return super.func_77653_i(stack);
    }

    public static Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subtypes) {
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(EntityHandler.getRegisteredDinosaurs());
        Collections.sort(dinosaurs);
        List<Dinosaur> dinosaursForType = fossilDinosaurs.get(this.type);
        if (this.func_194125_a(tab)) {
            for (Dinosaur dinosaur : dinosaurs) {
                if (!dinosaursForType.contains(dinosaur) || !this.fresh && dinosaur instanceof Hybrid) continue;
                subtypes.add((Object)new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dinosaur)));
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> lore, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Genetics") && nbt.func_74764_b("DNAQuality")) {
            int quality = nbt.func_74762_e("DNAQuality");
            TextFormatting colour = quality > 75 ? TextFormatting.GREEN : (quality > 50 ? TextFormatting.YELLOW : (quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
            lore.add(colour + LangUtils.translate(LangUtils.LORE.get("dna_quality"), new Object[0]).replace("{quality}", LangUtils.getFormattedQuality(quality)));
            lore.add(TextFormatting.BLUE + LangUtils.translate(LangUtils.LORE.get("genetic_code"), new Object[0]).replace("{code}", LangUtils.getFormattedGenetics(nbt.func_74779_i("Genetics"))));
        }
        if (((FossilItem)stack.func_77973_b()).getBoneType().equals("skull")) {
            FossilItem cfr_ignored_0 = (FossilItem)stack.func_77973_b();
            if (FossilItem.getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
                lore.add(TextFormatting.GOLD + LangUtils.translate("pose.name", new Object[0]) + ": " + LangUtils.getStandType(FossilItem.getHasStand(stack)));
                lore.add(TextFormatting.WHITE + LangUtils.translate("lore.change_variant.name", new Object[0]));
            }
        }
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public String getBoneType() {
        return this.type;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState blockstate = world.func_180495_p(pos);
        Block worldBlock = blockstate.func_177230_c();
        if (worldBlock.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
            pos = pos.func_177977_b();
        }
        if (!(worldBlock = world.func_180495_p(pos).func_177230_c()).func_176200_f((IBlockAccess)world, pos)) {
            if (!world.func_180495_p(pos).func_185904_a().func_76220_a() || !world.isSideSolid(pos, side, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.func_177972_a(side);
        }
        ItemStack stack = player.func_184586_b(hand);
        SkullDisplay block = BlockHandler.SKULL_DISPLAY;
        if (!player.field_70170_p.field_72995_K && player.func_175151_a(pos, side, stack) && world.func_190527_a((Block)block, pos, false, side, (Entity)null) && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull")) {
            FossilItem cfr_ignored_0 = (FossilItem)stack.func_77973_b();
            if (FossilItem.getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
                if (side == EnumFacing.DOWN) {
                    return EnumActionResult.FAIL;
                }
                if (block.func_176196_c(world, pos)) {
                    IBlockState blockstatePlacement = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
                    if (!world.func_180501_a(pos, blockstatePlacement, 11)) {
                        return EnumActionResult.FAIL;
                    }
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == block) {
                        ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                        block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                        if (player instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                        }
                    }
                    world.func_184133_a(null, pos, SoundType.field_185851_d.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185851_d.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185851_d.func_185847_b() * 0.8f);
                    SkullDisplayEntity tile = (SkullDisplayEntity)world.func_175625_s(pos);
                    if (tile != null) {
                        tile.setModel(stack.func_77952_i(), !this.isFresh(), FossilItem.getHasStand(stack));
                        EnumFacing.Axis axis = side.func_176740_k();
                        if (axis == EnumFacing.Axis.Y) {
                            tile.setAngle(FossilItem.angleToPlayer(pos, new Vector2d(player.field_70165_t, player.field_70161_v)));
                        } else if (axis == EnumFacing.Axis.X) {
                            tile.setAngle((short)side.func_185119_l());
                        } else if (axis == EnumFacing.Axis.Z) {
                            tile.setAngle((short)(180.0f + side.func_185119_l()));
                        }
                        world.func_184138_a(pos, state, state, 0);
                        tile.func_70296_d();
                        stack.func_190918_g(1);
                    }
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private static short angleToPlayer(BlockPos block, Vector2d player) {
        return (short)(90.0 - Math.toDegrees(Math.atan2((double)block.func_177952_p() + 0.5 - player.y, (double)block.func_177958_n() + 0.5 - player.x)));
    }

    public static boolean getHasStand(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Type")) {
            return stack.func_77978_p().func_74767_n("Type");
        }
        return true;
    }

    public static void setHasStand(ItemStack stack, boolean hasStand) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74757_a("Type", hasStand);
    }

    public static boolean changeStandType(ItemStack stack) {
        boolean newType = !FossilItem.getHasStand(stack);
        FossilItem.setHasStand(stack, newType);
        return newType;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && ((FossilItem)stack.func_77973_b()).getBoneType().equals("skull")) {
            FossilItem cfr_ignored_0 = (FossilItem)stack.func_77973_b();
            if (FossilItem.getDinosaur(stack).getClass() == TyrannosaurusDinosaur.class) {
                boolean oldType = FossilItem.getHasStand(stack);
                boolean type = FossilItem.changeStandType(stack);
                if (type != oldType && world.field_72995_K) {
                    TextComponentString change = new TextComponentString(LangUtils.translate(LangUtils.STAND_CHANGE.get("type"), new Object[0]).replace("{mode}", LangUtils.getStandType(type)));
                    change.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                    ClientProxy.MC.field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)change);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(6);
        if (outputType == 5 || this.fresh) {
            ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, stack.func_77952_i());
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 3) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        ArrayList list = Lists.newArrayList();
        fossilDinosaurs.get(this.type).forEach(dino -> list.add(new ItemStack((Item)this, 1, EntityHandler.getDinosaurId(dino))));
        return list;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        float single = 16.666666f;
        NBTTagCompound tag = inputItem.func_77978_p();
        ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, inputItem.func_77952_i());
        output.func_77982_d(tag);
        if (this.fresh) {
            return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(100.0f), (Object)output)});
        }
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Float.valueOf(single), (Object)output), Pair.of((Object)Float.valueOf(50.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 15)), Pair.of((Object)Float.valueOf(single * 2.0f), (Object)new ItemStack(Items.field_151145_ak))});
    }
}

