/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.genetics;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.jurassicraft.server.util.LangUtils;

public class PlantDNA {
    private int plant;
    private int quality;

    public PlantDNA(int plant, int quality) {
        this.plant = plant;
        this.quality = quality;
    }

    public static PlantDNA fromStack(ItemStack stack) {
        return PlantDNA.readFromNBT(stack.func_77978_p());
    }

    public static PlantDNA readFromNBT(NBTTagCompound nbt) {
        return new PlantDNA(nbt.func_74762_e("Plant"), nbt.func_74762_e("DNAQuality"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DNAQuality", this.quality);
        nbt.func_74768_a("Plant", this.plant);
        nbt.func_74778_a("StorageId", "PlantDNA");
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public int getPlant() {
        return this.plant;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(TextFormatting.DARK_AQUA + LangUtils.translate(LangUtils.LORE.get("plant"), new Object[0]).replace("{plant}", LangUtils.getPlantName(this.plant)));
        TextFormatting formatting = this.quality > 75 ? TextFormatting.GREEN : (this.quality > 50 ? TextFormatting.YELLOW : (this.quality > 25 ? TextFormatting.GOLD : (this.quality == -1 ? TextFormatting.AQUA : TextFormatting.RED)));
        tooltip.add(formatting + LangUtils.translate(LangUtils.LORE.get("dna_quality"), new Object[0]).replace("{quality}", LangUtils.getFormattedQuality(this.quality)));
    }

    public int getMetadata() {
        return this.plant;
    }
}

