/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.event;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.plant.DoublePlantBlock;
import org.jurassicraft.server.conf.JurassiCraftConfig;
import org.jurassicraft.server.entity.vehicle.HelicopterEntity;
import org.jurassicraft.server.entity.villager.VillagerHandler;
import org.jurassicraft.server.entity.villager.ai.EntityAIResearchFossil;
import org.jurassicraft.server.item.BugItem;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.util.GameRuleHandler;
import org.jurassicraft.server.world.WorldGenCoal;
import org.jurassicraft.server.world.loot.Loot;

public class ServerEventHandler {
    private static final ArrayList<Block> vinesException = new ArrayList();

    public static final ArrayList<Block> getVinesExceptions() {
        return vinesException;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        GameRuleHandler.register(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void blockRegistry(RegistryEvent.Register<Block> e) {
        e.getRegistry().register(BlockHandler.VINES.setRegistryName("minecraft", "vine"));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void decorate(DecorateBiomeEvent.Pre event) {
        IBlockState state;
        BlockPos topBlock;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Random rand = event.getRand();
        Biome biome = world.func_180494_b(pos);
        BiomeDecorator decorator = biome.field_76760_I;
        if (JurassiCraftConfig.MINERAL_GENERATION.plantFossilGeneration && decorator != null && decorator.field_180293_d != null && !(decorator.field_76821_k instanceof WorldGenCoal)) {
            decorator.field_76821_k = new WorldGenCoal(Blocks.field_150365_q.func_176223_P(), decorator.field_180293_d.field_177844_ac);
        }
        if (JurassiCraftConfig.PLANT_GENERATION.mossGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0) {
            topBlock = world.func_175672_r(pos);
            state = world.func_180495_p(topBlock);
            if (world.func_180495_p(topBlock.func_177977_b()).func_185914_p() && !state.func_185904_a().func_76224_d() && state.func_177230_c() != Blocks.field_150349_c && state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_150458_ak) {
                world.func_180501_a(topBlock, BlockHandler.MOSS.func_176223_P(), 18);
            }
        }
        if (JurassiCraftConfig.PLANT_GENERATION.flowerGeneration && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) && rand.nextInt(8) == 0) {
            topBlock = world.func_175672_r(pos);
            state = world.func_180495_p(topBlock);
            if (world.func_180495_p(topBlock.func_177977_b()).func_185914_p() && !state.func_185904_a().func_76224_d() && state.func_177230_c() != Blocks.field_150349_c && state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_150458_ak) {
                world.func_180501_a(topBlock.func_177984_a(), BlockHandler.WEST_INDIAN_LILAC.func_176223_P(), 18);
                world.func_180501_a(topBlock, BlockHandler.WEST_INDIAN_LILAC.func_176223_P().func_177226_a(DoublePlantBlock.HALF, (Comparable)((Object)DoublePlantBlock.BlockHalf.LOWER)), 18);
            }
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && rand.nextInt(8) == 0) {
            topBlock = world.func_175672_r(pos);
            state = world.func_180495_p(topBlock);
            if (world.func_180495_p(topBlock.func_177977_b()).func_185914_p() && !state.func_185904_a().func_76224_d() && state.func_177230_c() != Blocks.field_150349_c && state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_150458_ak) {
                world.func_180501_a(topBlock.func_177984_a(), BlockHandler.HELICONIA.func_176223_P(), 18);
                world.func_180501_a(topBlock, BlockHandler.HELICONIA.func_176223_P().func_177226_a(DoublePlantBlock.HALF, (Comparable)((Object)DoublePlantBlock.BlockHalf.LOWER)), 18);
            }
        }
        if (JurassiCraftConfig.PLANT_GENERATION.gracilariaGeneration && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && rand.nextInt(8) == 0 && (topBlock = world.func_175672_r(pos)).func_177956_o() < 62 && (state = world.func_180495_p(topBlock.func_177977_b())).func_185914_p()) {
            world.func_180501_a(topBlock, BlockHandler.GRACILARIA.func_176223_P(), 18);
        }
        if (JurassiCraftConfig.PLANT_GENERATION.peatGeneration && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && rand.nextInt(2) == 0) {
            new WorldGenMinable(BlockHandler.PEAT.func_176223_P(), 5, input -> input == Blocks.field_150346_d.func_176223_P() || input == Blocks.field_150349_c.func_176223_P()).func_180709_b(world, rand, world.func_175672_r(pos));
        }
        if (JurassiCraftConfig.MINERAL_GENERATION.trackwayGeneration) {
            int footprintChance = 20;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                footprintChance = 10;
            }
            if (rand.nextInt(footprintChance) == 0) {
                int y = rand.nextInt(20) + 30;
                FossilizedTrackwayBlock.TrackwayType type = FossilizedTrackwayBlock.TrackwayType.values()[rand.nextInt(FossilizedTrackwayBlock.TrackwayType.values().length)];
                for (int i = 0; i < rand.nextInt(2) + 1; ++i) {
                    BlockPos basePos = new BlockPos(pos.func_177958_n() + rand.nextInt(10) + 3, y, pos.func_177952_p() + rand.nextInt(10) + 3);
                    float angle = (float)(rand.nextDouble() * 360.0);
                    IBlockState trackway = BlockHandler.FOSSILIZED_TRACKWAY.func_176223_P().func_177226_a((IProperty)FossilizedTrackwayBlock.FACING, (Comparable)EnumFacing.func_176733_a((double)angle)).func_177226_a(FossilizedTrackwayBlock.VARIANT, (Comparable)((Object)type));
                    float xOffset = -MathHelper.func_76126_a((float)((float)Math.toRadians(angle)));
                    float zOffset = MathHelper.func_76134_b((float)((float)Math.toRadians(angle)));
                    for (int l = 0; l < rand.nextInt(2) + 3; ++l) {
                        BlockPos trackwayPos = basePos.func_177963_a((double)(xOffset * (float)l), 0.0, (double)(zOffset * (float)l));
                        if (world.func_180495_p(trackwayPos).func_177230_c() != Blocks.field_150348_b) continue;
                        world.func_180501_a(trackwayPos, trackway, 18);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootTable table = event.getTable();
        Loot.handleTable(table, name);
    }

    @SubscribeEvent
    public static void fall(LivingFallEvent e) {
        e.setCanceled(e.getEntity().func_184187_bx() instanceof HelicopterEntity);
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        Random rand = event.getWorld().field_73012_v;
        if (rand.nextInt(2) == 0) {
            ArrayList<BugItem> bugs = new ArrayList<BugItem>();
            if (state.func_177230_c() == Blocks.field_150407_cf) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            } else if (state.func_177230_c() == Blocks.field_150349_c) {
                if (rand.nextInt(6) == 0) {
                    bugs.add(ItemHandler.CRICKETS);
                }
            } else if (state.func_177230_c() == Blocks.field_150329_H) {
                if (rand.nextInt(5) == 0) {
                    bugs.add(ItemHandler.CRICKETS);
                }
            } else if (state.func_177230_c() == Blocks.field_150423_aK || state.func_177230_c() == Blocks.field_150440_ba) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            } else if (state.func_177230_c() == Blocks.field_150375_by) {
                bugs.add(ItemHandler.COCKROACHES);
                bugs.add(ItemHandler.MEALWORM_BEETLES);
            }
            if (bugs.size() > 0) {
                event.getDrops().add(new ItemStack((Item)bugs.get(rand.nextInt(bugs.size()))));
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            if (villager.getProfessionForge().equals((Object)VillagerHandler.PALEONTOLOGIST)) {
                villager.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIResearchFossil(villager, 0.4));
            }
            villager.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151037_a));
        }
    }

    static {
        vinesException.add((Block)BlockHandler.CLEAR_GLASS);
        vinesException.add((Block)BlockHandler.REINFORCED_GLASS);
    }
}

