/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.villager.ai;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.jurassicraft.server.block.FossilBlock;

public class EntityAIResearchFossil
extends EntityAIMoveToBlock {
    private final EntityVillager villager;
    private int currentTask;
    private static final int explorationRadius = 3;
    private static final int stayAtExploration = 60;
    private int staiedAtExploration = 0;
    private int stayRandom = 0;
    private int standingOffset = 0;
    private Random random;

    public EntityAIResearchFossil(EntityVillager villagerIn, double speedIn) {
        super((EntityCreature)villagerIn, speedIn, 16);
        this.villager = villagerIn;
        NBTTagCompound s = this.villager.getEntityData();
        if (!s.func_74764_b("SpawnLoc")) {
            s.func_74772_a("SpawnLoc", villagerIn.func_190671_u_().func_177986_g());
        }
        this.random = new Random();
    }

    public boolean func_75250_a() {
        double distance = Math.hypot(Math.abs(this.villager.func_174791_d().field_72449_c - (double)this.getSpawnLocation().func_177952_p()), Math.abs(this.villager.func_174791_d().field_72450_a - (double)this.getSpawnLocation().func_177958_n()));
        if (distance < 10.0) {
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.villager.field_70170_p, (Entity)this.villager)) {
                return false;
            }
            if (this.field_179496_a > 0) {
                --this.field_179496_a;
                return false;
            }
            this.field_179496_a = 20 + this.villager.func_70681_au().nextInt(10);
            this.currentTask = 0;
            this.staiedAtExploration = 0;
            return this.searchForDestination();
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.currentTask >= 0;
    }

    public BlockPos getSpawnLocation() {
        return BlockPos.func_177969_a((long)this.villager.getEntityData().func_74763_f("SpawnLoc"));
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.isAtDestination()) {
            if (this.staiedAtExploration == 0) {
                this.stayRandom = this.random.nextInt(40);
            }
            ++this.staiedAtExploration;
            this.setVillagerLook();
            if (this.staiedAtExploration == 20) {
                this.villager.field_70170_p.func_175655_b(this.field_179494_b.func_177982_a(this.standingOffset * -1, 0, 0), false);
            } else if (this.staiedAtExploration >= 60 + this.stayRandom) {
                if (!(this.villager.field_70170_p.func_180495_p(this.field_179494_b.func_177982_a(this.standingOffset * -1, -1, 0)).func_177230_c() instanceof FossilBlock)) {
                    this.villager.field_70170_p.func_184133_a(null, this.villager.func_190671_u_(), SoundType.field_185855_h.func_185841_e(), SoundCategory.BLOCKS, (SoundType.field_185855_h.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185855_h.func_185847_b() * 0.8f);
                    this.villager.field_70170_p.func_175656_a(this.field_179494_b.func_177982_a(this.standingOffset * -1, 0, 0), Blocks.field_150354_m.func_176223_P());
                }
                this.currentTask = -1;
            }
        }
    }

    protected boolean func_179488_a(World worldIn, BlockPos pos) {
        return true;
    }

    private void setVillagerLook() {
        this.villager.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + (double)this.standingOffset + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.villager.func_70646_bf());
        this.villager.func_70034_d(this.standingOffset == -1 ? 270.0f : 90.0f);
    }

    private boolean isAtDestination() {
        BlockPos vil = new BlockPos((Entity)this.villager);
        return this.func_179487_f() || vil.func_177958_n() == this.field_179494_b.func_177958_n() && vil.func_177952_p() == this.field_179494_b.func_177952_p() && Math.abs(vil.func_177956_o() - this.field_179494_b.func_177956_o()) <= 2;
    }

    private boolean searchForDestination() {
        BlockPos blockpos = new BlockPos((Entity)this.villager);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -3; y <= 3; ++y) {
                    BlockPos tmpPos = new BlockPos((Entity)this.villager).func_177982_a(x, y, z);
                    if (this.villager.field_70170_p.func_180495_p(tmpPos).func_177230_c() != Blocks.field_150354_m) continue;
                    candidates.add(tmpPos);
                }
            }
        }
        if (candidates.size() > 0) {
            Random random = new Random();
            BlockPos selectedPos = (BlockPos)candidates.get(random.nextInt(candidates.size()));
            while (this.villager.field_70170_p.func_180495_p(selectedPos.func_177984_a()).func_177230_c() == Blocks.field_150354_m) {
                selectedPos = selectedPos.func_177984_a();
            }
            this.standingOffset = selectedPos.func_177958_n() > blockpos.func_177958_n() ? -1 : 1;
            this.field_179494_b = selectedPos.func_177982_a(this.standingOffset, 0, 0);
            return true;
        }
        return false;
    }
}

