/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.util;

import java.util.Iterator;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnionTraverser
implements Iterable<BlockPos> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BlockPos _center;
    private final int _maxRadius;

    public OnionTraverser(BlockPos center, int radius) {
        this._center = center;
        this._maxRadius = radius;
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new OnionIterator();
    }

    public class OnionIterator
    implements Iterator<BlockPos> {
        private final int _maxCounter;
        private int _x;
        private int _minX;
        private int _maxX;
        private int _y;
        private int _z;
        private int _minZ;
        private int _maxZ;
        private int _currentRadius = 0;
        private int _yCounter = 1;
        private EnumFacing _facing;
        private boolean _returnedCenter = false;

        public OnionIterator() {
            this._maxCounter = OnionTraverser.this._maxRadius * 2 + 1;
            this._currentRadius = 1;
            this._y = OnionTraverser.this._center.func_177956_o();
            this.initRing();
        }

        @Override
        public boolean hasNext() {
            return this._currentRadius <= OnionTraverser.this._maxRadius;
        }

        @Override
        public BlockPos next() {
            if (!this._returnedCenter) {
                this._returnedCenter = true;
                return OnionTraverser.this._center;
            }
            BlockPos retVal = new BlockPos(this._x, this._y, this._z);
            if (this._y == OnionTraverser.this._center.func_177956_o() + OnionTraverser.this._maxRadius || this._y == OnionTraverser.this._center.func_177956_o() - OnionTraverser.this._maxRadius) {
                this.walkSlab();
            } else {
                this.walkPerimeter();
            }
            return retVal;
        }

        @Override
        public void remove() {
        }

        private void walkPerimeter() {
            switch (this._facing) {
                case EAST: {
                    if (this._x == this._maxX) {
                        ++this._z;
                        this._facing = EnumFacing.SOUTH;
                        break;
                    }
                    ++this._x;
                    break;
                }
                case SOUTH: {
                    if (this._z == this._maxZ) {
                        --this._x;
                        this._facing = EnumFacing.WEST;
                        break;
                    }
                    ++this._z;
                    break;
                }
                case WEST: {
                    if (this._x == this._minX) {
                        --this._z;
                        this._facing = EnumFacing.NORTH;
                        break;
                    }
                    --this._x;
                    break;
                }
                case NORTH: {
                    --this._z;
                    if (this._z != this._minZ) break;
                    this.nextLayer();
                    break;
                }
            }
        }

        private void walkSlab() {
            switch (this._facing) {
                case EAST: {
                    if (this._x == this._maxX) {
                        ++this._z;
                        this._facing = EnumFacing.WEST;
                        break;
                    }
                    ++this._x;
                    break;
                }
                case WEST: {
                    if (this._x == this._minX) {
                        ++this._z;
                        this._facing = EnumFacing.EAST;
                        break;
                    }
                    --this._x;
                    break;
                }
            }
            if (this._z > this._maxZ) {
                this.nextLayer();
            }
        }

        private void nextLayer() {
            ++this._yCounter;
            if (this._yCounter > this._maxCounter) {
                ++this._currentRadius;
                this.initRing();
            }
            this._x = this._minX;
            this._z = this._minZ;
            this._y = (this._yCounter & 1) == 1 ? OnionTraverser.this._center.func_177956_o() + this._yCounter / 2 : OnionTraverser.this._center.func_177956_o() - this._yCounter / 2;
            this._facing = EnumFacing.EAST;
        }

        private void initRing() {
            this._yCounter = 1;
            this._x = this._minX = OnionTraverser.this._center.func_177958_n() - this._currentRadius;
            this._z = this._minZ = OnionTraverser.this._center.func_177952_p() - this._currentRadius;
            this._y = OnionTraverser.this._center.func_177956_o();
            this._maxX = OnionTraverser.this._center.func_177958_n() + this._currentRadius;
            this._maxZ = OnionTraverser.this._center.func_177952_p() + this._currentRadius;
            this._facing = EnumFacing.EAST;
        }
    }
}

