/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="jurassicraft")
public class InterpValue
implements INBTSerializable<NBTTagCompound> {
    private static final List<InterpValue> INSTANCES = Lists.newArrayList();
    private static final List<InterpValue> MARKED_REMOVE = Lists.newArrayList();
    private final Supplier<Boolean> supplier;
    private double speed;
    private double target;
    private double current;
    private double previousCurrent;
    private boolean initilized;

    public InterpValue(Entity entity, double speed) {
        this(() -> ((Entity)entity).func_70089_S(), speed);
    }

    public InterpValue(Supplier<Boolean> supplier, double speed) {
        this.speed = speed;
        this.supplier = supplier;
        INSTANCES.add(this);
    }

    public void setTarget(double target) {
        if (!this.initilized) {
            this.initilized = true;
            this.reset(target);
        } else {
            this.target = target;
        }
    }

    public void reset(double target) {
        this.previousCurrent = target;
        this.current = target;
        this.target = target;
    }

    private void tickInterp() {
        if (!this.supplier.get().booleanValue()) {
            MARKED_REMOVE.add(this);
            return;
        }
        this.previousCurrent = this.current;
        this.current = Math.abs(this.current - this.target) <= this.speed ? this.target : (this.current < this.target ? (this.current += this.speed) : (this.current -= this.speed));
    }

    public double getValueForRendering(float partialTicks) {
        return this.previousCurrent + (this.current - this.previousCurrent) * (double)partialTicks;
    }

    public double getCurrent() {
        return this.current;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("target", this.target);
        tag.func_74780_a("current", this.current);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.target = nbt.func_74769_h("target");
        this.previousCurrent = this.current = nbt.func_74769_h("current");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onTick(TickEvent event) {
        Side side = FMLCommonHandler.instance().getSide();
        if (event instanceof TickEvent.ClientTickEvent && side.isClient() || event instanceof TickEvent.ServerTickEvent && side.isServer()) {
            List<InterpValue> list = INSTANCES;
            synchronized (list) {
                List<InterpValue> list2 = MARKED_REMOVE;
                synchronized (list2) {
                    INSTANCES.forEach(InterpValue::tickInterp);
                    MARKED_REMOVE.forEach(INSTANCES::remove);
                    MARKED_REMOVE.clear();
                }
            }
        }
    }
}

