/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import org.jurassicraft.server.entity.DinosaurEntity;

public class SmartBodyHelper
extends EntityBodyHelper {
    private static final float MAX_ROTATE = 75.0f;
    private static final int HISTORY_SIZE = 10;
    private final EntityLiving entity;
    private int rotateTime;
    private float targetYawHead;
    private double[] histPosX = new double[10];
    private double[] histPosZ = new double[10];

    public SmartBodyHelper(EntityLiving entity) {
        super((EntityLivingBase)entity);
        this.entity = entity;
    }

    public void func_75664_a() {
        if (!(this.entity.field_70128_L || this.entity instanceof DinosaurEntity && ((DinosaurEntity)this.entity).isCarcass())) {
            System.arraycopy(this.histPosX, 0, this.histPosX, 1, this.histPosX.length - 1);
            System.arraycopy(this.histPosZ, 0, this.histPosZ, 1, this.histPosZ.length - 1);
            this.histPosX[0] = this.entity.field_70165_t;
            this.histPosZ[0] = this.entity.field_70161_v;
            double dx = this.delta(this.histPosX);
            double dz = this.delta(this.histPosZ);
            double distSq = dx * dx + dz * dz;
            if (distSq > 2.5E-7) {
                double moveAngle = (float)MathHelper.func_181159_b((double)dz, (double)dx) * 57.295776f - 90.0f;
                this.entity.field_70761_aq = (float)((double)this.entity.field_70761_aq + MathHelper.func_76138_g((double)(moveAngle - (double)this.entity.field_70761_aq)) * (double)0.6f);
                if (!this.entity.func_70661_as().func_75500_f()) {
                    this.entity.field_70177_z = (float)((double)this.entity.field_70177_z + MathHelper.func_76138_g((double)(moveAngle - (double)this.entity.field_70177_z)) * (double)0.4f);
                }
            } else if (this.entity.func_184188_bt().isEmpty() || !(this.entity.func_184188_bt().get(0) instanceof EntityLiving)) {
                float limit = 75.0f;
                if (Math.abs(this.entity.field_70759_as - this.targetYawHead) > 15.0f) {
                    this.rotateTime = 0;
                    this.targetYawHead = this.entity.field_70759_as;
                } else {
                    ++this.rotateTime;
                    int speed = 30;
                    if (this.rotateTime > 30) {
                        limit = Math.max(1.0f - (float)(this.rotateTime - 30) / 30.0f, 0.0f) * 75.0f;
                    }
                }
                this.entity.field_70761_aq = this.approach(this.entity.field_70759_as, this.entity.field_70761_aq, limit);
            }
        }
    }

    private float approach(float target, float current, float limit) {
        float delta = MathHelper.func_76142_g((float)(target - current));
        if (delta < -limit) {
            delta = -limit;
        } else if (delta >= limit) {
            delta = limit;
        }
        return target - delta * 0.67f;
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double mean = 0.0;
        for (int i = 0; i < 5; ++i) {
            mean += arr[i + start];
        }
        return mean / (double)arr.length;
    }
}

